<?php 
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
add_theme_support('wc-product-gallery-zoom');
add_theme_support('woocommerce');


add_action('init','change_woocommerce_action');
function change_woocommerce_action() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
    remove_action( 'woocommerce_shop_loop_item_title','woocommerce_template_loop_product_title', 10 );
    remove_action( 'woocommerce_after_shop_loop_item','woocommerce_template_loop_add_to_cart', 10 );
    remove_action( 'woocommerce_before_single_product_summary' , 'woocommerce_show_product_sale_flash', 10 );
    remove_action( 'woocommerce_after_single_product_summary' , 'woocommerce_output_product_data_tabs', 10 );
    remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10 );
    remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );  
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );   
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );  
    remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
}

add_action('init','add_woocommerce_action');
function add_woocommerce_action() {
 add_action( 'woocommerce_single_product_summary' , 'jws_product_share', 50 );
 add_action( 'woocommerce_after_add_to_cart_button' , 'jws_add_to_wishlist_btn',30 );
}


function jwsChangeProductsTitle() {
   echo '<h5 class="woocommerce-loop-product__title"><a href="'.get_the_permalink().'">' . get_the_title() . '</a></h5>';
}
add_action('woocommerce_shop_loop_item_title', 'jwsChangeProductsTitle', 10 );

add_action( 'woocommerce_before_shop_loop_item_title', 'jws_product_label', 10 ); 

add_action( 'woocommerce_before_shop_loop_item_title', 'jws_product_thumbnail_gallery', 15 ); 

function jws_product_thumbnail_gallery() {
    global $product;
    $attachment_ids = $product->get_gallery_image_ids();
    if ( isset( $attachment_ids[0] ) ) {

		$attachment_id = $attachment_ids[0];

		$title = get_the_title();
        $size_img = 'woocommerce_thumbnail';
		$image = wp_get_attachment_image( $attachment_id, $size_img );

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<div class="gallery" title="%s">%s</div>', $title, $image ), $attachment_id, get_the_ID() );
	} 
}
    		


/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter('loop_shop_per_page', 'jws_new_loop_shop_per_page', 20);

function jws_new_loop_shop_per_page($cols)
{
    global $jws_option;
    // $cols contains the current number of products per page based on the value stored on Options -> Reading
    // Return the number of products you wanna show per page.
    $cols = (isset($jws_option['product_per_page']) && !empty($jws_option['product_per_page'])) ? $jws_option['product_per_page'] : 12;
    if(isset($_GET['number']) && $_GET['number']) {  
      $cols = $_GET['number'];  
    }
    return $cols;
}


function jws_button_product_grid($cart, $wishlist , $quickview) {
    ?>
        <ul class="ct_ul_ol">
            <?php if($cart) : ?>
            <li class="btn-cart"><?php woocommerce_template_loop_add_to_cart(); ?></li>
            <?php endif; ?>
            <?php if($wishlist && function_exists('jws_add_to_wishlist_btn')) : ?>
            <li class="btn-wishlist"><?php jws_add_to_wishlist_btn(); ?></li>
            <?php endif; ?>
            <?php if($quickview) : ?>
            <li class="btn-quickview">
                <a data-product_id="<?php echo get_the_ID(); ?>" class="quickview-button"> <i class="jws-icon-eye-thin"></i><span><?php echo esc_html__('Quick view','feedy') ?></span></a>
            </li>
            <?php endif; ?>
        </ul>
    <?php
}

if ( ! function_exists( 'jws_product_quickview_button' ) ) {
	/**
	 * Add wishlist Button to Product Image
	 */
	function jws_product_quickview_button() {

		?>
		<div class="quickview-icon">
			<button data-product_id="<?php echo get_the_ID(); ?>" class="quickview-button is-outline circle icon">
				<span class="lnr lnr-eye"></span>
                <div class="quickview-popup">
				    <?php echo esc_html__( 'Quick View', 'feedy' ); ?>
			    </div>
			</button>
		</div>
		<?php
	}
}
   
if( ! function_exists( 'jws_ajax_load_product_quickview' ) ) {
    	function jws_ajax_load_product_quickview($id = false) {
    		if( isset($_GET['id']) ) {
    			$id = (int) $_GET['id'];
    		}
    
    
    		global $post, $product;
    
    
    		$args = array( 'post__in' => array($id), 'post_type' => 'product' );
    
    		$quick_posts = get_posts( $args );
    
    	
    
    		foreach( $quick_posts as $post ) :
    			setup_postdata($post);
    			$product = wc_get_product($post);
                wc_get_template_part( 'quickview/content', 'quickview' );
    		endforeach; 
    
    		wp_reset_postdata(); 
    
    		die();
    	}
    
        
        // Note: Keep default AJAX actions in case WooCommerce endpoint URL is unavailable
        add_action('wp_ajax_jws_ajax_load_product_quickview', 'jws_ajax_load_product_quickview');
        add_action('wp_ajax_nopriv_jws_ajax_load_product_quickview', 'jws_ajax_load_product_quickview');
    
} 


if( ! function_exists( 'jws_product_label' ) ) {
	function jws_product_label() {
		global $product;

		$output = array();    
        $stock = true;

		if ( $product->is_on_sale() ) {

			$percentage = '';

			if ( $product->get_type() == 'variable' ) {

				$available_variations = $product->get_variation_prices();
				$max_percentage = 0;

				foreach( $available_variations['regular_price'] as $key => $regular_price ) {
					$sale_price = $available_variations['sale_price'][$key];

					if ( $sale_price < $regular_price ) {
						$percentage = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );

						if ( $percentage > $max_percentage ) {
							$max_percentage = $percentage;
						}
					}
				}

				$percentage = $max_percentage;
			} elseif ( ( $product->get_type() == 'simple' || $product->get_type() == 'external' ) ) {
				$percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
			}

			if ( $percentage ) {
				$output[] = '<span class="onsale jws_pr_label">' .$percentage . '%' . '</span>';
			}else{
				$output[] = '<span class="onsale jws_pr_label">' . esc_html__( 'Sale', 'feedy' ) . '</span>';
			}
		}
		
		if( !$product->is_in_stock() && $product->get_type() != 'variable' ){
			$output[] = '<span class="out-of-stock jws_pr_label">' . esc_html__( 'SOLD', 'feedy' ) . '</span>';
            $stock = false;
		}

		if ( $product->is_featured() && $stock) {
			$output[] = '<span class="featured jws_pr_label">' . esc_html__( 'Best Seller', 'feedy' ) . '</span>';
		}
   
		if ( get_post_meta( get_the_ID(), '_jws_new_enabled', true ) == 'yes' && $stock) {
			$output[] = '<span class="new jws_pr_label">' . esc_html__( 'New', 'feedy' ) . '</span>';
		}
		
        if ( get_post_meta( get_the_ID(), '_jws_limit_enabled', true ) == 'yes' && $stock) {
			$output[] = '<span class="limit jws_pr_label">' . esc_html__( 'Limited Edition', 'feedy' ) . '</span>';
		}
        
        $check_stock = $stock ? '' : 'out_stock';
		
		if ( $output ) {
			echo '<div class="jws_pr_labels '.$check_stock.'">' . implode( '', $output ) . '</div>';
		}
	}
}

if( ! function_exists( 'jws_nutri_info_single' ) ) { 
    
  function jws_nutri_info_single() {
        $slug = 'nutrition_calories';
        $nutrition = JwsMeals::jws_nutrition_data_config();
        $meta = get_post_meta( get_the_ID() , '_'.$slug, true );
        $tootip = esc_html__( 'Nutrition & allergen info', 'feedy' );
        if(!empty($meta) && is_product()) {
            
         printf(
                '<div class="nutrition-info">%s %s <a data-modal-jws="#jws-nutrition-info-popup" href="#" data-id="'.get_the_ID().'""><span>'.$tootip.'</span></a></div>',
                $meta,
                $nutrition[$slug]['unit']
         );
         ?>
         <div id="jws-nutrition-info-popup" class="mfp-hide">
             <?php
              get_template_part(    
                  'woocommerce/single-product/nutrition-info', '' , ''
              );    
             ?> 
         </div>
         <?php
        }       
       
  }    
  
}

add_action('jws_single_nutrition','jws_nutri_info_single',12);

function jws_nutrition_calories() { 
    
        $slug = 'nutrition_calories';
        $nutrition = JwsMeals::jws_nutrition_data_config();
        $meta = get_post_meta( get_the_ID() , '_'.$slug, true );
        
        if(!empty($meta)) {
            
         printf(
                '<span class="nutrition-info">%s %s</span>',
                $meta,
                $nutrition[$slug]['unit']
         );
     
        }     
        
}



if( ! function_exists( 'jws_product_share' ) ) {
	function jws_product_share() { ?>
	   
       <div class="product-share">
    
            <span class="share-label"><?php echo esc_html__('Share','feedy') ?></span>
          
            <span class="addthis_inline_share_toolbox" data-url="<?php the_permalink(); ?>" data-title="<?php the_title_attribute(); ?>">
            
                    <a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="fab fa-facebook"></i></a>
            
            		<a target="_blank" href="//plus.google.com/share?url=<?php the_permalink(); ?>"><i class="fab fa-google"></i></a>
            
            		<a  target="_blank" href="//twitter.com/share?url=<?php the_permalink(); ?>"><i class="fab fa-twitter"></i></a>

                    <a  target="_blank" href="//www.linkedin.com/shareArticle?mini=true&title=<?php echo get_the_title(); ?>&url=<?php  the_permalink(); ?>"><i class="fab fa-linkedin"></i></a>
                    
                    <a target="_blank"  href="//www.pinterest.com/pin/create/button/?url=<?php echo the_permalink(); ?>"><i class="fab fa-pinterest"></i></a>
               
           </span>     
       </div>
       
    <?php }
}    

add_filter( 'woocommerce_output_related_products_args', 'jws_related_products_args', 20 );
  function jws_related_products_args( $args ) {
	$args['posts_per_page'] = 100; // 4 related products

	return $args;
}



if (!function_exists('jws_shop_page_link')) {
    function jws_shop_page_link($keep_query = false, $link_out = '' ,$taxonomy = '')
    {
        // Base Link decided by current page
        if (defined('SHOP_IS_ON_FRONT')) {
            $link = home_url();
        } elseif (is_post_type_archive('product') || is_page(wc_get_page_id('shop'))) {
            $link = get_post_type_archive_link('product');

        } elseif (is_product_category()) {
            $link = get_term_link(get_query_var('product_cat'), 'product_cat');
        } elseif (is_product_tag()) {
            $link = get_term_link(get_query_var('product_tag'), 'product_tag');
        } else {
            $link = get_term_link(get_query_var('term'), get_query_var('taxonomy'));
        }
        
        if(!empty($link_out)) {
           $link = $link_out; 
        }

        if ($keep_query) {

            
            
            $link_array_slug = array(
                'min_price','max_price' ,'orderby','lay_style','shop_layout','layout','filter_layout'
                
            );
            
            
            foreach($link_array_slug as $get_slug) {
                if (isset($_GET[$get_slug])) {
                    $link = add_query_arg($get_slug, $_GET[$get_slug], $link);
                } 
            }
            
             // All current filters
            if ($_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes()) {

                foreach ($_chosen_attributes as $name => $data) {
                    if ($name === $taxonomy) {
                        continue;
                    }

                    $filter_name = sanitize_title(str_replace('pa_', '', $name));
                    if (!empty($data['terms'])) {
                        $link = add_query_arg('filter_' . $filter_name, implode(',', $data['terms']), $link);

                    }
                    if ('or' == $data['query_type']) {
                        $link = add_query_arg('query_type_' . $filter_name, 'or', $link);

                    }
                }
            }

            /**
             * Search Arg.
             * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
             */
            if (get_search_query()) {
                $link = add_query_arg('s', rawurlencode(wp_specialchars_decode(get_search_query())), $link);
            }

            
        }

        return $link;
    }
}


function wc_get_rating_html_compare( $rating ) { 
    if ( $rating > 0 ) { 
        $rating_html = '<div class="star-rating" title="' . sprintf( esc_attr__( 'Rated %s out of 5','feedy' ), $rating ) . '">'; 
        $rating_html .= '<span style="width:' . ( ( $rating / 5 ) * 100 ) . '%"><strong class="rating">' . $rating . '</strong> ' . esc_html__( 'out of 5','feedy' ) . '</span>'; 
        $rating_html .= '</div>'; 
    } else { 
        $rating_html = ''; 
    } 
    return $rating_html; 
}

function jws_is_shop() {
	if ( class_exists( 'WooCommerce' ) && is_shop() ) { // Shop Page
		return 'shop';
	}

	return apply_filters( 'jws_is_shop', false );
}

function jws_get_page_base_url() {
    	if ( defined( 'SHOP_IS_ON_FRONT' ) ) {
    		$link = home_url();
    	} elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
    		$link = get_post_type_archive_link( 'product' );
    	} elseif ( is_product_category() ) {
    		$link = get_term_link( get_query_var( 'product_cat' ), 'product_cat' );
    	} elseif ( is_product_tag() ) {
    		$link = get_term_link( get_query_var( 'product_tag' ), 'product_tag' );
    	} else {
    		$queried_object = get_queried_object();
    		$link   = get_term_link( $queried_object->slug, $queried_object->taxonomy );
    	}
    
    	return $link;
}



function shop_before_footer() {
  $id = jws_theme_get_option('select-before-footer-shop');
  echo !empty($id) ? '<div class="shop-before-footer">'.do_shortcode('[hf_template id="'.$id.'"]').'</div>' : '';     
}


function add_parameter_after_custom_link($link) {

		if ( isset( $_GET['layout'] ) ) {
			$link = add_query_arg( 'layout', wc_clean( $_GET['layout'] ), $link );
		}
        
        if ( isset( $_GET['lay_style'] ) ) {
			$link = add_query_arg( 'lay_style', wc_clean( $_GET['lay_style'] ), $link );
		}
        if ( isset( $_GET['shop_layout'] ) ) {
			$link = add_query_arg( 'shop_layout', wc_clean( $_GET['shop_layout'] ), $link );
		}  
        if ( isset( $_GET['filter_layout'] ) ) {
			$link = add_query_arg( 'filter_layout', wc_clean( $_GET['filter_layout'] ), $link );
		}  
        return $link;
}



/** Woocommerce Customize Items Extention **/


add_filter( 'woocommerce_product_write_panel_tabs', 'jws_add_customize_items_tab', 98 );
add_action( 'woocommerce_product_data_panels', 'jws_customize_items_tab_options');


function jws_add_customize_items_tab() {

    ?>
    
    <li class="customize_items_options customize_items_tab hide_if_grouped hide_if_external">
    	<a href="#customize_items_tab"><span><?php esc_html_e( 'Jws Product Setting', 'feedy' ); ?></span></a>
    </li>

<?php

}

function jws_customize_items_tab_options() {

		global $post;

		$product = wc_get_product( $post );

		?>

		<div id="customize_items_tab" class="panel woocommerce_options_panel">

			<div class="options_group">

				<?php
                    
                   
                    woocommerce_wp_checkbox(
    					array(
    						'id'            => '_jws_new_enabled',
    						'wrapper_class' => '',
    						'label'         => esc_html__( 'Enable New Label', 'feedy' ),
    						'description'   => esc_html__( 'Enable New Label display in product item', 'feedy' )
    					)
    				);
            
                 
                	?>

			</div>
		</div>
		<?php
	}


add_filter( 'woocommerce_product_write_panel_tabs', 'jws_add_jws_nutrition_items_tab', 98 );
add_action( 'woocommerce_product_data_panels', 'jws_jws_nutrition_items_tab_options');


function jws_add_jws_nutrition_items_tab() {

    ?>
    
    <li class="jws_nutrition_items_options jws_nutrition_items_tab hide_if_grouped hide_if_external">
    	<a href="#jws_nutrition_items_tab"><span><?php esc_html_e( 'Jws Nutrition Facts', 'feedy' ); ?></span></a>
    </li>

<?php

}

function jws_jws_nutrition_items_tab_options() {

		global $post;

		$product = wc_get_product( $post );

        foreach ( JwsMeals::jws_nutrition_data_config() as $key_nutrition => $nutrition ) {
			${$key_nutrition} = $product->get_meta( '_' . $key_nutrition );
		}
        
        $serving_size  = $product->get_meta( '_serving_size' );
  

		?>

		<div id="jws_nutrition_items_tab" class="panel woocommerce_options_panel">

			<div class="options_group">
                <p class="form-field">
                    <label for="_serving_size"><?php echo esc_html__( 'Serving Size','feedy' ); ?></label>
                    <input type="text" class="wc_input_decimal" name="_serving_size" placeholder="2000"
                           id="_serving_size" value="<?php echo esc_attr($serving_size); ?>">
                </p>
				<?php
    
                  foreach ( JwsMeals::jws_nutrition_data_config() as $key_nutrition => $nutrition ): ?>
                        <p class="form-field">
                            <label for="_<?php echo esc_attr( $key_nutrition ); ?>"><?php echo esc_html( $nutrition['label'] ).' ('.$nutrition['unit'].')'; ?></label>
                            <input type="text" class="wc_input_decimal" name="_<?php echo esc_attr( $key_nutrition ); ?>" placeholder="<?php echo esc_attr( $nutrition['placeholder'] ); ?>"
                                   id="_<?php echo esc_attr( $key_nutrition ); ?>" value="<?php echo esc_attr(${$key_nutrition}); ?>">
                        </p>
            	  <?php endforeach; ?>
             
        
			</div>
            
            <?php 
             
                acf_form( [
                    'post_id' => get_the_ID(),
                    'field_groups' => ['product_ingredient'],
                    'form' => false,
                ]); 
            
            ?>
		</div>
		<?php
}

function jws_nutrition_product() { 
    
    
    $nutritions = jws_theme_get_option('nutrition_in_product');
    $config = JwsMeals::jws_nutrition_data_config();
    
    if(count($nutritions['enabled']) > 1) {
            unset($nutritions['enabled']['placebo']);
            echo '<ul class="nutritions-list reset_ul_ol">';
            foreach($nutritions['enabled'] as $key => $value) {
                
                $meta = get_post_meta( get_the_ID() , '_'.$key, true );
                echo !empty($meta) ? '<li>'.$meta.$config[$key]['unit'].'<span>'.$config[$key]['frontend_label'].'</span></li>' : '';
                
            }
            echo '</ul>';
        
    }

    
    
}


/**
 * Save the custom field
 * @since 1.0.0
 */
function jws_save_items_field( $post_id ) {
    
 $product = wc_get_product( $post_id );

 $new = isset( $_POST['_jws_new_enabled'] ) && !empty($_POST['_jws_new_enabled']) ? 'yes' : 'no';
 
 $serving_size = isset( $_POST['_serving_size'] ) && is_numeric( $_POST['_serving_size'] )  ? $_POST['_serving_size'] : '';
 
 $product->update_meta_data( '_serving_size', $serving_size);


 $product->update_meta_data( '_jws_new_enabled', $new);
 
 foreach ( JwsMeals::jws_nutrition_data_config() as $key_nutrition => $nutrition ) {
	if ( isset( $_POST[ '_' . $key_nutrition ] ) && is_numeric( $_POST[ '_' . $key_nutrition ] ) ) {
		$product->update_meta_data( '_' . $key_nutrition, $_POST[ '_' . $key_nutrition ] );
	} else {
		$product->update_meta_data( '_' . $key_nutrition, '' );
	}
 }
 if (!empty($_POST['acf'])) {
    foreach($_POST['acf'] as $key => $value) {
        update_field($key, $value, $post_id);
    }
  }

 $product->save();
}
add_action( 'woocommerce_process_product_meta', 'jws_save_items_field' );



add_filter('woocommerce_product_categories_widget_args', 'jws_custom_product_categories_widget_args', 10, 1);

function jws_custom_product_categories_widget_args($args) {
  require JWS_ABS_PATH . '/woocommerce/includes/walkers/class-wc-product-cat-list-walker.php';
  $args['walker'] = new Custom_WC_Product_Cat_List_Walker;
  return $args;
}

function jws_woo_found() {
    global $wp_query;
    // Define each variable again (before using it)
    $paged    = max( 1, $wp_query->get( 'paged' ) );
    $per_page = $wp_query->get( 'posts_per_page' );
    $total    = $wp_query->found_posts;
    $first    = ( $per_page * $paged ) - $per_page + 1;
    $last     = min( $total, $wp_query->get( 'posts_per_page' ) * $paged );
    $current = (get_query_var('paged')) ? get_query_var('paged') : 1; 

	// phpcs:disable WordPress.Security
	if ( 1 === intval( $total ) ) {
		_e( 'Single result', 'feedy' );
	} elseif ( $total <= $per_page || -1 === $per_page ) {
		/* translators: %d: total results */
		printf( _n( '%d product', '%d products', $total, 'feedy' ), $total );
	} else {
		$first = ( $per_page * $current ) - $per_page + 1;
		$last  = min( $total, $per_page * $current );
		/* translators: 1: first result 2: last result 3: total results */
		printf( _nx( 'Showing <span class="found-min">%1$d&ndash;</span>%2$d of %3$d result', 'Showing <span class="found-min">%1$d&ndash;</span class="found-total">%2$d <span class="result-total">of %3$d</span> results', $total, 'with first and last result', 'feedy' ), $first, $last, $total );
	}
}

/**
 * Get coupon display HTML.
 *
 * @param string|WC_Coupon $coupon Coupon data or code.
 */
function jws_wc_cart_totals_coupon_html( $coupon ) {
	if ( is_string( $coupon ) ) {
		$coupon = new WC_Coupon( $coupon );
	}

	$discount_amount_html = '';

	$amount               = WC()->cart->get_coupon_discount_amount( $coupon->get_code(), WC()->cart->display_cart_ex_tax );
	$discount_amount_html = '-' . wc_price( $amount );

	if ( $coupon->get_free_shipping() && empty( $amount ) ) {
		$discount_amount_html = __( 'Free shipping coupon', 'feedy' );
	}

	$discount_amount_html = apply_filters( 'woocommerce_coupon_discount_amount_html', $discount_amount_html, $coupon );
	$coupon_html          =   ' <a href="' . esc_url( add_query_arg( 'remove_coupon', rawurlencode( $coupon->get_code() ), wc_get_checkout_url()  ) ) . '" class="woocommerce-remove-coupon" data-coupon="' . esc_attr( $coupon->get_code() ) . '"><span>' . $coupon->get_code(). '</span></a>'.$discount_amount_html;

	echo wp_kses( apply_filters( 'woocommerce_cart_totals_coupon_html', $coupon_html, $coupon, $discount_amount_html ), array_replace_recursive( wp_kses_allowed_html( 'post' ), array( 'a' => array( 'data-coupon' => true ) ) ) ); // phpcs:ignore PHPCompatibility.PHP.NewFunctions.array_replace_recursiveFound
}




function jws_check_layout_shop() {
    global $jws_option;
    $value = array();
    
    // select-shop-top_filter //
    if(isset($jws_option['select-shop-top_filter'])) {
      $value['select-shop-top_filter'] = $jws_option['select-shop-top_filter'];  
    }
    
    // columns_review //
    
    if(isset($jws_option['columns_review'])) {
      $value['columns_review'] = $jws_option['columns_review'];  
    }
    
    
    
    // shop_pagination_layout //
    $layout = isset($jws_option['shop_pagination_layout']) ? $jws_option['shop_pagination_layout'] : 'number';
    
    $value['shop_pagination_layout'] = $layout; 
    
    
    
    // fullwidth //
 
    $fullwidth = (isset($jws_option['shop-fullwidth-switch']) && $jws_option['shop-fullwidth-switch']) ? $jws_option['shop-fullwidth-switch'] : false;  
   
    $value['fullwidth']  = $fullwidth;
    
    
    
    // position //
    if(isset($_GET['layout']) && $_GET['layout']) { 
      $position = $_GET['layout']; 
    }else{
      $position = (isset($jws_option['shop_position_sidebar']) && $jws_option['shop_position_sidebar']) ? $jws_option['shop_position_sidebar'] : 'no_sidebar'; 
      
    }  
    $value['position']  = $position;
    
    
    
    
    // filter_layout //
    if(isset($_GET['filter_layout']) && $_GET['filter_layout']) { 
      $filter_layout = $_GET['filter_layout'];  
    }else{
      $filter_layout = (isset($jws_option['shop_click_filter']) && $jws_option['shop_click_filter']) ? $jws_option['shop_click_filter'] : 'bottom'; 
    }   
    $value['filter_layout']  = $filter_layout; 
    
    
    
    // class_wap //
    $value['class_wap']  = 'shop-container';
    if($fullwidth) {
       $value['class_wap'] .= ' no_container' ;
    }else {
       $value['class_wap'] .= ' container' ; 
    }
    if($position == 'no_sidebar' && $filter_layout != 'sideout') {
       $value['content_col'] = 'shop-content col-12'; 
       $value['sidebar_col'] = 'shop-sidebar sidebar_sticky ';
       $value['class_wap'] .= ' sidebar-no_sidebar'; 
    }else {
       $value['content_col'] = 'shop-content col-xl-9 col-lg-12 col-12';
       $value['sidebar_col'] = 'shop-sidebar col-xl-3 col-lg-12 col-12';
       $value['class_wap'] .= ' sidebar-has_sidebar';  
    }
    
    if($filter_layout == 'sideout') {
       $value['class_wap'] .= ' sidebar-sideout'; 
    } 
    
 
    
    $columns = (isset($jws_option['shop_columns']) && !empty($jws_option['shop_columns']) ) ? $jws_option['shop_columns'] : '3';
    $getlayout   = isset($_GET['lay_style']) ? $_GET['lay_style'] : $columns; 
    $value['shop_columns'] = $getlayout;
    
    
    
     
    
    $layout = (isset($jws_option['shop_layout']) && $getlayout != '1' ) ? $jws_option['shop_layout'] : 'layout2';

    if($getlayout == '1') {
        $layout = '';
    }
    $value['layout'] = $layout; 
    
    
    

    return $value;
}


function custom_pre_get_posts_query( $q ) {

    $tax_query = (array) $q->get( 'tax_query' );
    $meta_query = (array) $q->get( 'meta_query' );
 

    global $jws_option;

    if(isset($jws_option['exclude-product-in-shop']) && !empty($jws_option['exclude-product-in-shop'])) {
        $result = array_map('intval', array_filter($jws_option['exclude-product-in-shop'], 'is_numeric'));
        $q->set('post__not_in' , $result); // use integers
    }
    if(isset($jws_option['exclude-category-in-shop']) && !empty($jws_option['exclude-category-in-shop'])) {
        $tax_query[] = array(
               'taxonomy' => 'product_cat',
               'field' => 'id',
               'terms' => $jws_option['exclude-category-in-shop'], // Don't display products in the clothing category on the shop page.
               'operator' => 'NOT IN'
        );
    }

    $q->set( 'tax_query', $tax_query );
    $q->set( 'meta_query', $meta_query );

   
}
add_action( 'woocommerce_product_query', 'custom_pre_get_posts_query' );


add_filter( 'woocommerce_product_categories_widget_args', 'jws_product_cat_widget_args' );
function jws_product_cat_widget_args( $cat_args ) {
    $option = jws_theme_get_option('exclude-category-in-shop');
    if(!empty($option)) {
      $cat_args['exclude'] = $option;  
    }

    return $cat_args;
}



if(!function_exists('jws_add_to_box_text')) {
    
    function jws_add_to_box_text($args) {
        
        $args = wp_parse_args( $args, array(
            'id'   =>  get_the_ID(),
            'class'  => '',
        ) );

        extract( $args );
        
        $products = wc_get_product($id);
        
        $class = 'add_to_cart_button ajax-meal-to-cart button';
 
        if( $products->is_type( 'variable' ) ){ 
          $text = esc_html__('Add','feedy');
          $class .= ' product-variable';
        }else {
          $text = esc_html__('Add','feedy');
        }
        ?>
        <a href="javascript:void(0);" class="<?php echo esc_attr($class); ?>" data-id="<?php echo get_the_ID(); ?>"><span><?php echo esc_html($text);?></span></a>
        <?php  
      
    }
    
}