<?php
$id = get_the_ID();
$serving_size =  get_post_meta( $id , '_serving_size' , true);
?>

<h5>
 <?php echo esc_html__('Nutritional Info','feedy'); ?>
</h5>
<?php if(!empty($serving_size)) :
 
	echo sprintf(
    		'<div class="serving_size fw-700 cl-heading">%s: %sg</div>',
            esc_html__('Serving size','feedy'),
            $serving_size
   	);

endif; ?>
<table class="nutritions-table">
 
 <thead>
  
  <tr>
    <th></th>
    <?php if(!empty($serving_size)) : ?>
    <th class="per-serve"><?php echo esc_html__('Ave Qty Per Serve','feedy'); ?></th>
    <?php endif; ?>
    <th class="serve-g"><?php echo esc_html__('100g','feedy'); ?></th>
  </tr>
 
 </thead>
 
 <tbody>
   
 <?php  
     $nutritions_config = JwsMeals::jws_nutrition_data_config();
     $nutritions = JwsMeals::get_nutrition_list();
     if(!empty($nutritions)) : foreach($nutritions as $key => $nutrition): ?> 
  
       <tr>
          <td> <?php echo esc_html($nutritions_config[$key]['frontend_label'].' ('.$nutritions_config[$key]['unit'].')'); ?> </td>
          <?php if(!empty($serving_size)) : ?>
          <td class="per-serve"> <?php echo (int) $serving_size * ( (int) $nutrition / 100); ?> </td>
          <?php endif; ?>
          <td class="serve-g"> <?php echo esc_html($nutrition); ?> </td>
       </tr>

  <?php endforeach; endif; ?>
 
 </tbody>

</table>
<?php $ingredient = get_field('ingredient_content');  ?>
<?php if(!empty($ingredient)) :  $ingredient = preg_split('/\R+/', $ingredient, 0, PREG_SPLIT_NO_EMPTY);  ?>
<div class="ingredient-wap">
 
 <div class="nut-heading fw-700 cl-heading"><?php echo esc_html__('Ingredient:','feedy'); ?></div>
 
 <?php 

 
      foreach($ingredient as $value) {
         
         echo '<span>'.$value.'</span>';
        
      }
 

  ?>
 
</div>
<?php endif; ?>

<?php 

 $allergen = get_field('allergen');
 $allergen_status = jws_allergen_status();
 $allergen_description_global = jws_theme_get_option('allergen_description_global'); 
 $allergen_file_global = jws_theme_get_option('allergen_file');
 $allergen_description =  get_field('allergen_description');
 $allergen_file =  get_field('allergen_file'); 
 
 if(!empty($allergen_description)) {
    $allergen_description_global = $allergen_description;
 }
 
 if($allergen_file) {
    $allergen_file_global['url'] = $allergen_file;
 }
 
?>

<div class="allergen-wap">
   <?php if(!empty($allergen)) : ?>
   <div class="nut-heading fw-700 cl-heading"><?php echo esc_html__('Allergen Information:','feedy'); ?></div>
   <?php
   
     echo '<ul class="reset_ul_ol allergen-list">';
          foreach($allergen as $value) {
             
             echo '<li><div><strong>'.$value['ingredient'].':</strong><span>'.$allergen_status[$value['status']].'</span></div></li>';
            
          }
     echo '</ul>';
     endif; 
     
     if(!empty($allergen_description_global)) : ?>
      <div class="allergen-description">
       
       <?php echo ''.$allergen_description_global; ?>
      
      </div>
     <?php endif; 
     
      if(isset($allergen_file_global['url'])) : ?>
      <a class="allergen-file" target="_blank" href="<?php echo esc_attr($allergen_file_global['url']); ?>"><?php echo esc_html__('View our Allergen Disclaimer','feedy'); ?></a>
     <?php endif; ?>
</div>

