<?php
 
 $args = wp_parse_args( $args, array(
    'product_id'   =>  get_the_ID(),
 ) );
 extract( $args );
 
 global $product;

?>
<div class="meals-product-detail">

    <div class="detail-top">
     
     <div class="images">
    
        <?php 
        
        $attach_id = get_post_thumbnail_id($product_id);
        $image = jws_image_advanced(array('attach_id' => $attach_id, 'thumb_size' => 'full'));
        echo !empty($image) ? $image : ''; 
        jws_product_label();
        ?>
    
    </div>
    <div class="content">
    
    <?php 
                     
        woocommerce_template_single_title();
        woocommerce_template_single_price(); 
        echo '<div class="product-tags">'.get_the_term_list(get_the_ID(), 'product_tag', '', '').'</div>';
        woocommerce_template_single_excerpt();
    ?>
       
    </div>
    
    </div>
    
    <div class="detail-center">
        <?php $ingredient = get_field('ingredient_content');  ?>
        <div class="row">
            
            <?php if(!empty($ingredient)) :  $ingredient = preg_split('/\R+/', $ingredient, 0, PREG_SPLIT_NO_EMPTY);  ?> 
            
            <div class="col-xl-6 col-12">
              
              <div class="ingredient-wap">
                 
                 <h6><?php echo esc_html__('Ingredient','feedy'); ?></h6>
                 
                 <?php 
               
                      echo '<ul class="reset_ul_ol">';
                      
                      foreach($ingredient as $value) {
                         
                         echo '<li>- '.$value.'</li>';
                        
                      }
                      
                      echo '</ul>';
               
                  ?>
                 
              </div>
            
            
            </div>
            
            <?php endif; ?>
            
            <?php 
            
            $nutritions = JwsMeals::get_nutrition_list();
         
            if(!empty($nutritions)) : ?> 
            
            <div class="col-xl-6 col-12">
            
               <div class="nutrition-wap">
               
                 <h6><?php echo esc_html__('Nutrition facts','feedy'); ?></h6>
                 <p class="fs-small"><?php echo esc_html__('Information per serving.','feedy'); ?></p>
                 
                 <div class="nutrition-row row">
                   
                   <?php  
                   
                       $nutritions_config = JwsMeals::jws_nutrition_data_config();
                       
                       foreach($nutritions  as $key => $nutrition) {
                  
                            
                          $total = jws_theme_get_option($key); 
                          
                          $value = $nutrition;
                         
                          if(empty($value)  ||  !$total) continue;
                          
                          $progress =  $value / $total * 100;
                          
                          ?>
                            
                            <div class="nutrition-item col-xl-6 col-lg-6 <?php echo esc_attr($key); ?>">
                               
                               <label class="cl-heading fw-700 fs-small"><?php echo esc_html($nutritions_config[$key]['frontend_label']); ?></label>
                               
                               <div class="value">
                                  
                                  <?php echo esc_html($value.' '.$nutritions_config[$key]['unit']); ?>
                               
                               </div>
                               
                               <div class="progress-bar">
                                 <span style="width: <?php echo esc_attr($progress); ?>%;"></span>
                               </div>
                               <p class="dv fs-small"><?php echo round($progress); ?>% DV</p>
                            
                            </div>
                          
                          
                          <?php
               
                          
                        
                       }
                       
                       
                       
                    
                    ?>
                 
                 </div>
                 
               </div>
            
            </div>
            
            <?php endif; ?>
            
        </div>
    </div>
    
    <?php jws_add_to_box_text(array('id' => get_the_ID() , 'class' => ' button-custom')) ;?>
          
</div>