<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage feedy
 * @since 1.0.0
 */
global $jws_option; 
    $post_id = get_the_ID();
    $comments_number = get_comments_number();
    $archive_year  = get_the_time('Y'); 
	$archive_month = get_the_time('m'); 
	$archive_day   = get_the_time('d');
    $start_date = get_post_meta($post_id,'events_date',true);
    $locatgion = get_post_meta($post_id,'events_location',true);
    $image_size = (isset($jws_option['single_events_imagesize']) && !empty($jws_option['single_events_imagesize'])) ? $jws_option['single_events_imagesize'] : 'full';
    
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <header>
            
              
                
                <div class="post-media<?php if(!has_post_thumbnail()) echo esc_attr(' post-no-thumbnail'); ?>">
                     
                        <?php 
                        
                              $attach_id = get_post_thumbnail_id();
                              $image = jws_image_advanced(array('attach_id' => $attach_id, 'thumb_size' => $image_size));
                              echo !empty($image) ? $image : '';     
                      ?>
                   
                </div>
                
               <div class="jws-post-info">
                   <div class="post-date">
     
                     <?php
                      
                      $date = !empty($start_date) ? $start_date : get_the_date();
                      $date = str_replace("/", "-", $date);
                      $date = date_create($date);
                
                     
                     ?>
                    
                    <div class="date-inner">
                        <div class="date-day h2">
                          <?php echo date_format($date,"d"); ?>
                        </div>
                        <div class="date-month h5">
                          <?php echo date_format($date,"M"); ?>
                        </div>
                    </div>
                    
                    </div> 
                    <div class="post-info">
                    <h3 class="post-title">
                        <?php echo get_the_title(); ?>
                    </h3>
                    <?php 
                     
                        if(!empty($locatgion)) {
                
                            echo '<div class="post-location fs-small cl-third"><i class="jws-icon-map-marker-solid"></i>'.$locatgion.'</div>';
                            
                            
                         }
                    
                     ?>
                     </div>
                    
                </div> 
                 <a href="<?php echo jws_theme_get_option('events_booking_url'); ?>" class="button-default events-booking"><?php echo esc_html__('Book a table','feedy'); ?></a> 
           </header>
           <div class="entry_content">
                <?php the_content(); ?> 
           </div>
           <div class="clear-both"></div>  


</article><!-- #post-<?php the_ID(); ?> -->
