<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage feedy
 * @since 1.0.0
 */
global $jws_option; 

    $comments_number = get_comments_number();
    $archive_year  = get_the_time('Y'); 
	$archive_month = get_the_time('m'); 
	$archive_day   = get_the_time('d');
    $gallery = get_post_meta( get_the_ID(), 'blog_gallery', true );
    $image_size = (isset($jws_option['single_blog_imagesize']) && !empty($jws_option['single_blog_imagesize'])) ? $jws_option['single_blog_imagesize'] : 'full';
    $format = get_post_format();
    
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <header>
            
               <div class="jws-post-info">
                   <div class="post-meta fs-small">
                        <span class="post-date"><a href="<?php echo esc_url(get_day_link($archive_year, $archive_month, $archive_day)); ?>"><?php echo get_the_date(); ?></a></span>
                        <span class="post-cat uppercase"><?php echo get_the_term_list(get_the_ID(), 'category', '', ', '); ?></span> 
                   </div> 
                    <h1 class="post-title">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <div class="post-description">
                            <?php  echo get_the_excerpt(); ?>
                    </div>
                </div>
                
                  <div class="post-media<?php if(!has_post_thumbnail()) echo esc_attr(' post-no-thumbnail'); ?>">
                     
                        <?php 
                        
                              $attach_id = get_post_thumbnail_id();
                              $image = jws_image_advanced(array('attach_id' => $attach_id, 'thumb_size' => $image_size));
                              echo !empty($image) ? $image : '';     
                      ?>
                   
                </div>

           
                
           </header>
           <div class="entry_content">
                <?php the_content(); ?> 
           </div>
           <div class="clear-both"></div>
           <footer>
                <div class="row">
                    <div class="col-xl-7 col-lg-6 col-12">
                        <?php echo jws_get_tags(); ?>
                    </div>
                    <div class="col-xl-5 col-lg-6 col-12">
                        <?php if(function_exists('jws_share_buttons')) echo jws_share_buttons(); ?>
                    </div>
                </div>
                <?php 
                    
                    get_template_part( 'template-parts/content/blog/single/template/author_box/author_box1' );
                    get_template_part( 'template-parts/content/blog/single/template/nav/nav2' ); 

                     // If comments are open or we have at least one comment, load up the comment template.
    				if ( comments_open() || get_comments_number() ) {
    					comments_template();
    				}
                 ?>
            </footer>   
		<?php
		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'feedy' ),
				'after'  => '</div>',
			)
		);
		?>

</article><!-- #post-<?php the_ID(); ?> -->
