<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage feedy
 * @since 1.0.0
 */

get_header();
wp_enqueue_script( 'stick-content', JWS_URI_PATH. '/assets/js/sticky_content.js', array(), '', true );
global $jws_option; 

$sidebar = (isset($_GET['sidebar']) && $_GET['sidebar'] == 'full' ) ? $_GET['sidebar'] : (isset($jws_option['position_sidebar_events_single']) && $jws_option['position_sidebar_events_single'] ? $jws_option['position_sidebar_events_single'] : 'right');

if($sidebar == 'full'|| ((did_action( 'elementor/loaded' )) && \Elementor\Plugin::$instance->editor->is_edit_mode()) || empty($jws_option)) {
   $content_col = 'col-xl-12 col-12'; 
   $sidebar_col = 'postt_sidebar sidebar-has_sidebar main-sidebar';
   $class = ' no_sidebar';
}else {
   $content_col = 'post_content col-xl-60 col-lg-12 col-12';
   $sidebar_col = 'post_sidebar sidebar-has_sidebar main-sidebar col-xl-40 col-lg-12 col-12'; 
   $class = ' has_sidebar'; 
}
$position_sidebar = (isset($jws_option['position_sidebar_events_single'])) ? $jws_option['position_sidebar_events_single'] : 'right';
$class .= ' sidebar_'.$position_sidebar;

$format = get_post_format();
?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
            <div class="<?php echo esc_attr($class); ?>">
            <div class="container">
                <div class="row">
                    <?php if($sidebar == 'left') : ?>
                        <div class="<?php echo esc_attr($sidebar_col); ?>">
                            <?php
                                if (isset($jws_option['select-sidebar-events-single']) && !empty($jws_option['select-sidebar-events-single'])) { 
                                             echo do_shortcode('[hf_template id="' . $jws_option['select-sidebar-events-single'] . '"]'); 
                                }	
    		                 ?>
                        </div>
                    <?php endif; ?>    
                    <div class="<?php echo esc_attr($content_col); ?>">
                        <?php
                			/* Start the Loop */
                			while ( have_posts() ) :
                				the_post();
                              
                                   get_template_part( 'template-parts/content/events/single/content' );
                            
                                the_posts_navigation();
                			endwhile; // End of the loop.
        
                            
            			?>
                        
                    </div>
                    <?php if($sidebar == 'right') : ?>
                        <div class="<?php echo esc_attr($sidebar_col); ?>">
                              <div class="main-sidebar jws_sticky_move">
                                    <div class="jws-filter-modal">
                                    <div class="modal-overlay"></div>
                                    <div class="siderbar-inner jws-scrollbar modal-content sidebar">
                                    <div class="modal-top">
                                        <span class="modal-close">Close</span>
                                    </div>
                                	<?php
                                         if (isset($jws_option['select-sidebar-events-single']) && !empty($jws_option['select-sidebar-events-single'])) { 
                                                 echo do_shortcode('[hf_template id="' . $jws_option['select-sidebar-events-single'] . '"]'); 
                                        }	
            		                 ?>
                                     </div>
                                     </div>
                            </div>
                        </div>
                    <?php endif; ?> 
                </div>
           </div>      
            </div>
		</main><!-- #main -->
	</div><!-- #primary -->
<?php
get_footer();