<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
} 
// **********************************************************************// 
// ! Add favicon 
// **********************************************************************// 
if (!function_exists('jws_favicon')) {
    function jws_favicon()
    {

        if (function_exists('has_site_icon') && has_site_icon()) return '';

        // Get the favicon.
        $favicon = '';


        global $jws_option;
        
        if(isset($jws_option['favicon']) && !empty($jws_option['favicon'])) {
            $favicon = $jws_option['favicon']['url'];
        }

        ?>
        <link rel="shortcut icon" href="<?php echo esc_attr($favicon); ?>">
        <link rel="apple-touch-icon-precomposed" sizes="152x152" href="<?php echo esc_attr($favicon); ?>">
        <?php
    }

    add_action('wp_head', 'jws_favicon');
}

if (!function_exists('jws_logo_url')) {
    function jws_logo_url()
    {

        $logo = '';
        global $jws_option;
        
        if(isset($jws_option['logo']) && !empty($jws_option['logo'])) {
            if(!empty($jws_option['logo'])) {
                $logo = $jws_option['logo']['url'];
            }
        }
        
        return $logo;

      
    }
}

//Lets add Open Graph Meta Info
 
function jws_insert_fb_in_head() {
    global $post;
    if ( !is_singular()) //if it is not a post or a page
        return;
        echo '<meta property="og:title" content="' . get_the_title() . '"/>';
        echo '<meta property="og:type" content="article"/>';
        echo '<meta property="og:url" content="' . get_permalink() . '"/>';
        echo '<meta property="og:site_name" content="'.get_bloginfo( 'name' ).'"/>';
    if(has_post_thumbnail( $post->ID )) { //the post does not have featured image, use a default image
        $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
        echo '<meta property="og:image" content="' . esc_attr( !empty($thumbnail_src[0]) ? $thumbnail_src[0] : '' ) . '"/>';
        echo '<meta property="og:image:secure_url" content="' . esc_attr( !empty($thumbnail_src[0]) ? $thumbnail_src[0] : ''  ) . '">';
        echo '<meta property="og:image:width" content="500">';
        echo '<meta property="og:image:height" content="400">';
    }

    echo "
";
}
add_action( 'wp_head', 'jws_insert_fb_in_head', 5 );


/**
 * Add extra initialisation for Contact 7 Form in Elementor popups.
 **/
add_action( 'wp_footer', 'jws_back_top_top'); 
function jws_back_top_top() {
    
    if(is_embed()) return;
    
    global $jws_option;
 
    $class = 'backToTop';
    ?>
        <a href="#" class="<?php echo esc_attr($class); ?>"><span></span></a>
    <?php
}

/**
 * Add toolbar for mobile.
 **/
add_action( 'wp_footer', 'jws_toolbar_mobile'); 

function jws_toolbar_mobile() {
    
    if(is_embed()) return;
     
    $enable = jws_theme_get_option('toolbar_fix');
    $tool_page = get_post_meta( get_the_ID(), 'tool_bar_checkbox', true );
    if($tool_page) {
           $enable = false;
    }  
 
     
    if (class_exists('Woocommerce') && $enable) { 
    $shop = jws_check_layout_shop();
    ?>
        <div class="jws-toolbar-wap">
            <?php  if(is_home() || (is_single() && 'post' == get_post_type()) || (is_single() && 'events' == get_post_type())) : ?>
            <div class="jws-toolbar-item">
                <a class="show_filter_shop" href="javascript:void(0)">
                    <i aria-hidden="true" class="jws-icon-bars-solid"></i>
                    <span><?php echo esc_html__('Sidebar','feedy'); ?></span>
                </a>
            </div>
            <?php endif; ?>
            <?php  if(is_shop() && ($shop['filter_layout'] == 'sideout' || $shop['position'] == 'left' || $shop['position'] == 'right')) : ?>
            <div class="jws-toolbar-item">
                <a class="show_filter_shop" href="javascript:void(0)">
                    <i aria-hidden="true" class="jws-icon-bars-solid"></i>
                    <span><?php echo esc_html__('Filter','feedy'); ?></span>
                </a>
            </div>
            <?php endif; ?>
            <?php if(jws_theme_get_option('toolbar_shop')) : ?>
            <div class="jws-toolbar-item">
                <a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>">
                    <i aria-hidden="true" class="jws-icon-store-alt-solid"></i>
                    <span><?php echo esc_html__('Shop','feedy'); ?></span>
                </a>
            </div>
            <?php endif; ?>
            <?php if(jws_theme_get_option('toolbar_search')) : ?>
            <div class="jws-toolbar-item">
                <a class="jws_toolbar_search" href="#" data-modal-jws="#form_content_popup">
                    <i aria-hidden="true" class="jws-icon-search-solid"></i>
                    <span><?php echo esc_html__('Search','feedy'); ?></span>
                </a>
            </div>
            <?php endif; ?>
            <?php if(jws_theme_get_option('toolbar_account')) : ?>
            <div class="jws-toolbar-item">
                <a class="jws-open-login<?php if(is_user_logged_in()) echo ' logged'; ?>" href="<?php echo get_author_posts_url( get_current_user_id() ); ?>">
                    <i aria-hidden="true" class="jws-icon-user-circle"></i>
                    <span><?php echo esc_html__('My account','feedy'); ?></span>
                </a>
            </div>
             <?php endif; ?>
             <?php  if((is_single() && 'meals' == get_post_type())) : ?>
            <div class="jws-toolbar-item">
                <a class="show-meals-cart" href="javascript:void(0)">
                    <i aria-hidden="true" class="jws-icon-shopping-cart-solid"></i>
                    <span><?php echo esc_html__('Meals Cart','feedy'); ?></span>
                </a>
            </div>
            <?php endif; ?>
            <?php 
                $custom_toolbar = jws_theme_get_option('toolbar_custom');
                $i = 0;
                if(!empty($custom_toolbar['redux_repeater_data'])) {
                   foreach($custom_toolbar['redux_repeater_data'] as $value) {
                        if(!empty($custom_toolbar['toolbar_custom_link'][$i])) {
                        ?>
                          <div class="jws-toolbar-item">
                                <a href="<?php echo esc_url($custom_toolbar['toolbar_custom_link'][$i]); ?>">
                                    <i aria-hidden="true" class="<?php echo esc_attr($custom_toolbar['toolbar_custom_icon'][$i]); ?>"></i>
                                    <span><?php echo esc_html($custom_toolbar['toolbar_custom_name'][$i]); ?></span>
                                </a>
                          </div>
                        <?php
                        }
                    $i++;} 
                }
             ?> 
        </div>
    <?php
    }
}


/**
 * Add form login.
 **/
add_action( 'wp_footer', 'jws_form_login_popup'); 
function jws_form_login_popup() {
    if(is_embed()) return;
    global $jws_option;
    ?>
        <div class="jws-form-login-popup jws-scrollbar">
            <div class="jws-form-overlay"></div>
            <div class="jws-form-content">
                <div class="jws-close"><i aria-hidden="true" class="jws-icon-x"></i></div>
                <?php jws_get_content_form_login(true,true,'login'); ?>
            </div>
        </div>
    <?php
}

/**
 * Add form search.
 **/
add_action( 'wp_footer', 'jws_form_search_popup'); 
function jws_form_search_popup() {
global $jws_option;
?>    
<div id="form_content_popup" class="form_content_popup mfp-hide"> 
<div class="jws-search-form">
    	<form role="search" method="get" class="searchform jws-ajax-search" action="<?php echo esc_url( home_url( '/' ) ); ?>" data-count="20" data-post_type="movies" data-thumbnail="1" data-price="1">
			<?php 
               $exclude_term = jws_theme_get_option('exclude-category-in-shop');     
               wc_product_dropdown_categories(
    				apply_filters(
    					'woocommerce_product_categories_widget_dropdown_args',
    				
    						array(
    							'show_count'         => false,
    							'hierarchical'       => true,
    							'selected'           =>  '',
                                'class'              => 'dropdown_product_cat_search',
                                'value_field'        => 'id',
                                'exclude'            => $exclude_term ,
                                'show_option_none'   => __( 'Select a category', 'feedy' ), 
    						)
    					
    				)
    			);
                $args = array( 
        			'hide_empty' => 1,
        			'parent' => 0
        		);
                $option = jws_theme_get_option('exclude-category-in-shop');
                if(!empty($option)) {
                  $args['exclude'] = $option;  
                }
            ?>
            <input type="text" class="s" placeholder="<?php echo esc_attr_x( 'Search', 'placeholder', 'feedy' ); ?>..." value="<?php echo get_search_query(); ?>" name="s" />
			<input type="hidden" name="term" value="">
			<button type="submit" class="searchsubmit">
		       <i aria-hidden="true" class="jws-icon-search-solid"></i>
			</button>
            <span class="form-loader">
            </span>
		</form>
        <div class="search-results-wrapper"><div class="jws-search-results row jws-scrollbar"></div></div>
</div>   
</div>
<?php
}

/**
 * Add newseleter popup.
 **/
add_action( 'wp_footer', 'jws_form_newsletter_popup'); 
function jws_form_newsletter_popup() {
    if(is_embed()) return;    
    global $jws_option;
    if(jws_theme_get_option('newsletter_enble') && !is_page( 'Landing Page' ) && (did_action( 'elementor/loaded' ) && !\Elementor\Plugin::$instance->preview->is_preview_mode()))    :
    ?>
        <div class="jws-newsletter-popup mfp-hide">
            <div class="jws-form-content">
                <div class="newsletter-content">
                    <?php 
                        if(isset($jws_option['newsletter_content'])){
                             echo do_shortcode('[hf_template id="'.$jws_option['newsletter_content'].'"]');
                        }
                    ?>
               </div>
            </div>
        </div>
    <?php endif; ?>    
    <?php
}


/**
 * Add extra initialisation for Contact 7 Form in Elementor popups.
 **/
function jws_ct_body_classes( $classes ) {
    if(is_embed()) return $classes;
    global $jws_option;
    $layout = (isset($jws_option['button-layout'])) ? $jws_option['button-layout'] : 'default';
    $tool_bar = jws_theme_get_option('toolbar_fix');
    $classes[] = 'button-'.$layout;
    if ( !is_user_logged_in() ) {
            $classes[] = 'user-not-logged-in';
    }
  
    if($tool_bar) {
        $classes[] = 'has-tool-bar';
    }

    
    if(isset($jws_option['shop_single_layout'])) {
       $classes[] = 'single-product-'.$jws_option['shop_single_layout']; 
    }
    
    
    if(isset($jws_option['container_layout'])) {
       $classes[] = 'container-'.$jws_option['container_layout']; 
    }

    /** rtl **/
    $classes[] = (isset($jws_option['rtl']) && $jws_option['rtl']) ? 'rtl' : '';
    
    $header_fix = jws_theme_get_option('turn_on_header_sidebar');
    if(!$header_fix && is_page()) {
        $header_fix = get_post_meta( get_the_ID(), 'turn_on_header_sidebar', 1 );
     } 
    if($header_fix)  {
        $classes[] = 'has-header-side';
    }
    
    
    if(isset($_GET['absolute']) && $_GET['absolute'] == 'true') {
        $classes[] = 'header-absolute';
    }
    
    if (!defined('feedycore') )  {
        $classes[] = 'elementor-not-load';
    }
    
      
    return $classes;
}
add_filter( 'body_class','jws_ct_body_classes' );

function jws_mini_cart_content2() { ?>
        <div class="jws-mini-cart-wrapper">
            <div class="jws-cart-sidebar">
                <div class="jws_cart_content">
                </div>
            </div>
            <div class="jws-cart-overlay"></div>
        </div>   
<?php }
if (class_exists('Woocommerce')) { 
   add_action( 'wp_footer', 'jws_mini_cart_content2' ); 
}

function jws_mouse_pointer() {
    
    if(jws_theme_get_option('mouse_move')) {
        
         ?>
         
         <div class="jws-cursor jws-js-cursor"><div class="jws-cursor-wrapper"><div class="jws-cursor--follower jws-js-follower"></div><div class="jws-cursor--label jws-js-label"></div><div class="jws-cursor--drap jws-js-drap"></div><div class="jws-cursor--icon jws-js-icon"></div></div></div>
        
        
        <?php 
    }
}

add_action( 'wp_footer', 'jws_mouse_pointer' ); 



function jws_filter_backups_demos($demos)
	{
		$demos_array = array(
			'feedy' => array(
				'title' => esc_html__('feedy', 'feedy'),
				'screenshot' => 'https://gavencreative.com/import_demo/feedy/screenshot.jpg',
				'preview_link' => 'https://feedy.jwsuperthemes.com/',
			),
		);
        $download_url = 'https://gavencreative.com/import_demo/feedy/download-script/';
		foreach ($demos_array as $id => $data) {
			$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
				'url' => $download_url,
				'file_id' => $id,
			));
			$demo->set_title($data['title']);
			$demo->set_screenshot($data['screenshot']);
			$demo->set_preview_link($data['preview_link']);
			$demos[$demo->get_id()] = $demo;
			unset($demo);
		}
		return $demos;
}
add_filter('fw:ext:backups-demo:demos', 'jws_filter_backups_demos');
if (!function_exists('jws_deactivate_plugins')){
	function jws_deactivate_plugins() {
		deactivate_plugins(array(
			'brizy/brizy.php'
		));    
		
	}
}
add_action( 'admin_init', 'jws_deactivate_plugins' );


add_action( 'admin_menu', 'jws_add_menu_page' );
if(!function_exists('jws_add_menu_page')) {
  function jws_add_menu_page() {
    add_menu_page( 'Jws Settings', 'Jws Settings', 'manage_options', 'jws_settings', 'jws_settings', '', 1 );
  }  
}

function purchase_code_page() {
   add_submenu_page(
    'jws_settings',
    'Check Purchase Code',
    'Check Purchase Code',
    'manage_options',
    'purchase_code',
    'jws_settings', 1  );  
}

add_action( 'admin_menu', 'purchase_code_page' );

function jws_settings() {
    
    
    $jws_purchase_code = get_option( 'jws_purchase_code' );
    $jws_token = get_option( 'jws_token' );  

    ?>
    
    
    <form class="form-wrap" id="check_purchase_code">
    
        
        <h4><?php echo esc_html__('Check Purchase Code','feedy'); ?></h4>  
        
        <div>
        
            <?php 
                
                echo esc_html__('Verify the license to be able to plugin update functionality.','feedy');
            
            
            ?>
        
        </div>
          
        <p class="form-field"><label><?php echo esc_html__('Your personal tokens','feedy'); ?></label><input autocomplete="off" type="text" value="<?php echo isset($jws_token) ?  $jws_token : ''; ?>" name="token" /></p>
        
        <p class="form-field"><label><?php echo esc_html__('Purchase Code','feedy'); ?></label><input autocomplete="off" type="text" value="<?php echo isset($jws_purchase_code) ?  $jws_purchase_code : ''; ?>" name="purchase_code" /></p>
        
        <p class="form-field"><button class="button button-primary" type="submit"><?php echo esc_html__('Submit','feedy'); ?></button></p>
        
        
        <div class="data-return">
            
            <?php
            
    
               if(get_option('jws_license') == 'good') {
                 $data_li = get_option('jws_license_data');   
                 echo '<span class="success">'.esc_html__('Successful License.','feedy').'</span>';
                 if(!empty($data_li)) {
                    echo '<div>';
                     
                        echo '<span>'.esc_html__('Sold at: ','feedy').$data_li['sold_at'].'</span>';
                        echo '<span>'.esc_html__('License: ','feedy').$data_li['license'].'</span>';
                     
                    echo '</div>';
                 }
                 
                 
                 
               } else {
                
                 echo '<span class="error">'.esc_html__('You haven\'t verified your license yet.','feedy').'</span>';
                    
               }
            
             ?>
        
        
        </div>
        
        <div class="note">
        
        
            <a href="https://build.envato.com/my-apps/" target="_blank"> <?php echo esc_html__('Create your personal tokens here','feedy'); ?> </a>
            
            <p>And add these 3 permissions to the token.</p>
            <ul>
                <li>View and search Envato sites</li>
                <li>Verify purchases of your items</li>
                <li>Verify purchases you've made</li>
            </ul>
        
        </div>
        
    </form>
    
    
    <?php

}

  
add_action('wp_ajax_check_purchase_code','check_purchase_code');
  

function check_purchase_code() {
    
    $args = wp_parse_args( $_POST, array(
        'purchase_code'  =>  '',
        'token'  =>  '',
        'item_id' => '49344711'
    ) );

    extract( $args );
    
        if(isset($purchase_code)) {
             update_option( 'jws_purchase_code', $purchase_code );
        }
        
        if(isset($token)) {
             update_option( 'jws_token', $token );
        }


        $url = "https://api.envato.com/v3/market/buyer/purchase?code=$purchase_code";
        
        $headers = array(
            'Authorization' => "Bearer $token",
            "User-Agent: Purchase code verification script"
        );
        
        $response = wp_remote_get($url, array('headers' => $headers));
        
        $response_code = wp_remote_retrieve_response_code($response);

        if ($response_code === 401 || $response_code === 404 || $response_code === 403) { 
            
            $body = wp_remote_retrieve_body($response);
            $data = json_decode($body, true);
            wp_send_json_error( $data );
            
        }   
        if ($response_code === 200) {
            
            $body = wp_remote_retrieve_body($response);
            $data = json_decode($body, true);
       
            
            if ($data['item']['id'] == $item_id) {

                update_option( 'jws_license', 'good' );
                update_option( 'jws_license_data', array('sold_at' => $data['sold_at'],'license' => $data['license']) );
                wp_send_json_success($data);
                
            } else {
                update_option( 'jws_license', 'bad' );
                wp_send_json_error(array('error'=>'This code is not from the theme author.'));
                
            }
            
            
        } else {
            
            update_option( 'jws_license', 'bad' );
            
        }
        
        wp_send_json_error( array('error'=>'Purchase code is incorrect.') );
 
}       
        


// Hide all posts from users who are not logged-in or are not administrators or members
function jws_exclude_posts($query) {
  global $jws_option;
  $meta_query = (array) $query->get( 'meta_query' );
  if(isset($jws_option['exclude-blog']) && !empty($jws_option['exclude-blog'])) {
     $result = array_map('intval', array_filter($jws_option['exclude-blog'], 'is_numeric'));
     if(!is_admin() && $query->is_main_query() && !is_single()){
        set_query_var('post__not_in', $result);
    }  
  }
  if(isset($jws_option['select-product-meals']) && !empty($jws_option['select-product-meals'])) {
     $result = array($jws_option['select-product-meals']);
     if(!is_admin() && $query->is_main_query()){
        set_query_var('post__not_in', $result);
    }  
  }
  if ( $query->is_post_type_archive( 'questions' ) && $query->is_main_query() && ! is_admin() ) {
    $query->set( 'posts_per_page', jws_theme_get_option('auestions-number') );
    if(isset($_GET['product_questions'])) {
        
         $meta_query[] = array(
            array(
    				'key'     => 'product_questions',
    				'value'   => sanitize_text_field( $_GET['product_questions'] ),
    				'compare' => 'LIKE',
    		)
       ) ;
	
    }
     
  }

 $query->set( 'meta_query', $meta_query );
  
}
add_action('pre_get_posts', 'jws_exclude_posts');



add_filter( 'woocommerce_products_widget_query_args', 'custom_products_widget_query_arg', 10, 1 );

function custom_products_widget_query_arg( $query_args ) {
    if( ! is_admin() )
     if(jws_theme_get_option('select-product-meals')) {
     $result = array(jws_theme_get_option('select-product-meals'));
        $query_args['post__not_in'] = $result;
  }
  return $query_args;
}
