<?php

defined( 'ABSPATH' ) || exit;


if( ! class_exists( 'JwsMeals' ) ) {

	class JwsMeals {

        protected $total_nu	=	array(); 
            
		public function __construct() {


			add_action( 'jws_meals/nav_section',  array($this,'nav_section') , 10, 2 );
            add_action( 'jws_meals/nav_step',  array($this,'nav_step') , 10, 2 );
            add_action( 'jws_meals/meals_carts',  array($this,'meals_carts') , 10, 2 );
            
            add_action( 'wp_ajax_nopriv_add_meals_to_cart', array($this,'add_meals_to_cart') );
            add_action( 'wp_ajax_add_meals_to_cart', array($this,'add_meals_to_cart') );
            
            add_action( 'wp_ajax_nopriv_reset_meals_to_cart', array($this,'reset_meals_to_cart') );
            add_action( 'wp_ajax_reset_meals_to_cart', array($this,'reset_meals_to_cart') );
   
            add_action( 'wp_ajax_nopriv_change_meals_quanlity_cart', array($this,'change_meals_quanlity_cart') );
            add_action( 'wp_ajax_change_meals_quanlity_cart', array($this,'change_meals_quanlity_cart') );
            
            add_action('wp_ajax_meals_ajax_add_to_cart', array($this,'jws_meals_ajax_add_to_cart'));
            add_action('wp_ajax_nopriv_meals_ajax_add_to_cart', array($this,'jws_meals_ajax_add_to_cart'));
            
            add_action('wp_ajax_edit_meals_cart', array($this,'edit_meals_cart'));
            add_action('wp_ajax_nopriv_edit_meals_cart', array($this,'edit_meals_cart'));
            
            add_action( 'wp_enqueue_scripts', array($this , 'meals_load_js'));  
            	// Add to cart.
		    add_filter( 'woocommerce_add_cart_item', array( $this, 'add_cart_item' ), 20, 1 );
            // Add to cart.
	    	add_filter( 'woocommerce_get_cart_item_from_session', array( $this, 'get_cart_item_from_session' ), 20, 2 );
            
            add_action('wp_ajax_meal_detail', array($this,'meal_detail'));
            add_action('wp_ajax_nopriv_meal_detail', array($this,'meal_detail'));
            
		}
        
        public function meals_load_js() {
  
             wp_localize_script(
        			'jquery',
        			'jws_meals',
        			array(
                        'meals_id' => get_the_ID(),
        			)
        	);
       
            
        }
            
         public function add_cart_item( $cart_item ) {
    		if ( ! empty( $cart_item['insurance_price'] )  ) {
    			if ( $cart_item['insurance_price'] !== 0 ) {
    					$price = (float) $cart_item['insurance_price'];
    			}
    
    			$cart_item['data']->set_price( $price );
    		}
    
    		return $cart_item;
    	}
     
        
        public function get_cart_item_from_session( $cart_item, $values ) {
   
          	if ( ! empty( $values['meal_data'] ) ) {
    			$cart_item['meal_data'] = $values['meal_data'];
                $cart_item['meal_id'] = $values['meal_id'];
                $cart_item['insurance_price'] = $values['insurance_price'];
    			$cart_item = $this->add_cart_item( $cart_item );
    		}
    
    		return $cart_item;
            
        }
        
        public function edit_meals_cart() { 

           if(isset($_POST['order_id'])) {
            
            
            $order = wc_get_order( $_POST['order_id'] );

			foreach ( $order->get_items() as $item_id => $item ) { 	
			 
				   if($item_id == $_POST['order_key']) {
					   
					   	$edit_data = $item->get_meta( 'meal_data', true );
					   
				   }
				

			}   
   
            $key_cookies = 'meals_'.$_POST['meals'];
            setcookie( $key_cookies , json_encode( $edit_data ), 0, COOKIEPATH, COOKIE_DOMAIN, false, false );
            $meal_url = get_the_permalink($_POST['meals']);
 
            $order_received_url = wc_get_endpoint_url( 'view-order', $_POST['order_id'] , wc_get_page_permalink( 'myaccount' ) );
			$order_received_url = add_query_arg( 'key', $_POST['order_key'], $order_received_url );
							
             wp_send_json_success(compact( 'edit_data' , 'meal_url' ));  
            
           } else {
              
              if(isset($_POST['cart'])) {
                    
                        $edit_data =  WC()->cart->get_cart();
                        $edit_data = isset($edit_data[$_POST['cart']]) ? $edit_data[$_POST['cart']] : '';
                        if(isset($edit_data['meal_data'])) {
                           $edit_data['meal_data']['cart_key'] = $_POST['cart'];  
                           $key_cookies = 'meals_'.$_POST['meals'];
                           setcookie( $key_cookies , json_encode( $edit_data['meal_data'] ), 0, COOKIEPATH, COOKIE_DOMAIN, false, false );
                           $meal_url = get_the_permalink($_POST['meals']);
                        }  
                        
                        wp_send_json_success(compact( 'edit_data' , 'meal_url' ));  
             }
              
           } 
           
            
               
            
    
            
        }
        
        public function jws_meals_ajax_add_to_cart() {
            
            $args = array(
                'meal_id'   =>  $_POST['meal_id'],
            );
   
             $data = $this->get_meals_data($args); 
      
            if ( isset($_POST['meal_id']) ) {
                $product_id     = intval(jws_theme_get_option('select-product-meals'));
                $price          = floatval($data['total_price']);
                $ebike_ids      = array();
                $insurance_ids  = array();
                $found          = false;
                $ebike_quantity = 1;
                $custom_value = array();
        
                // Loop through cart items
                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    // Delete all preexisting insurance products
                    if ( in_array( $cart_item['product_id'],  $insurance_ids ) ) {
                        WC()->cart->remove_cart_item( $cart_item_key );
                    }
        
                    // Get ebikes total quantity
                    if ( in_array( $cart_item['product_id'],  $ebike_ids ) ) {
                        $ebike_quantity +=  $cart_item['quantity'];
                    }
                }
                $cart_item['insurance_price'] = $price;
             
               
                // If command is not to remove add insurance product with price as custom cart item data
                if ( $price >= 0 && $cart_item['insurance_price'] > 0 ) {
        
                  $custom_value['insurance_price']  = $price;
                  $custom_value['meal_id']  = $_POST['meal_id'];
                  $data['meal_id']  = $_POST['meal_id'];
                  $custom_value['meal_data']  = $data;
            
                  WC()->cart->add_to_cart( $product_id, $ebike_quantity, 0, array(),$custom_value);
                  
                }
                
                
                if(isset($data['cart_key'])) {
    
                     $cart = WC()->instance()->cart;
                     $cart->set_quantity($data['cart_key'],0);
        
                }  
                
                $key_cookies = 'meals_'.$_POST['meal_id'];
                $products = array();
                setcookie( $key_cookies , json_encode( $products ), 0, COOKIEPATH, COOKIE_DOMAIN, false, false );
                wp_send_json_success( $data );
               
            }
            
            
        }
         
   
        private function number_meals($id){
             return get_post_meta( $id , 'number_meals' , true);
        }
        
        public static function get_meals_data($args){ 
      
            $args = wp_parse_args( $args, array(
                'meal_id'   =>  get_the_ID(),
                'reset_datas' => false,
                'data_ajax' => ''
            ) );
            
            extract( $args );
            
 
            if($reset_datas) return '';

            if(!empty($data_ajax)) {
                $datas = $data_ajax;
            } else {
                $datas = isset($_COOKIE[ 'meals_'.$meal_id ]) ? json_decode( wp_unslash( $_COOKIE[ 'meals_'.$meal_id ] ), true ) : '' ;
            }   

            return $datas;

            
        }
        
        public function nav_step(){ 
            
 
           $args = apply_filters( 'jws_meals/filters/nav_step',  array(
            
              'plan' => array(
                'status' => 'complete',
                'label'  => esc_html__('Select Plan','feedy'),
              ),
              'meals' => array(
                'status' => 'current',
                'label'  => esc_html__('Select Meals','feedy'),
              ),
              'add_ons' => array(
                'status' => '',
                'label'  => esc_html__('Add-Ons','feedy'),
              ),
              'checkout' => array(
                'status' => '',
                'label'  => esc_html__('Checkout','feedy'),
              ), 
            
           ) );
           
           if(isset($_GET['step']) && $_GET['step'] == 'add_ons') { 
             
             $args['meals']['status'] = 'complete';
             $args['add_ons']['status'] = 'current';
             
           }
     
           ?>
            
            <div class="nav-step">
               
               <ul class="reset_ul_ol">
               
               <?php 
                   
                   $number = 1;
                   
                   foreach($args as $key => $item) {
                    
                     echo '<li><a class="'.$item['status'].'" href="'.add_query_arg( 'step', $key , get_the_permalink() ).'" data-step="'.$key.'"><span class="number-step">'.$number.'</span><span class="text">'.$item['label'].'</span></a></li>';
                    
                   $number++ ;  }

                   ?>
               
               </ul>
             
             </div>
            
            
            <?php
        
        }

	
		public function nav_section($args){
           
           
          if(!empty($args)) {
 
             ?>

             <div class="nav-section">
               
               <ul class="reset_ul_ol">
               
               <?php 
               
                   foreach($args as $key => $item) {
                    
                     echo '<li><a href="#section_'.$key.'">'.$item['title'].'</a></li>';
                    
                   }

                   ?>
               
               </ul>
             
             </div>
             
             
             <?php

          }
		

		}
        
        public function meals_carts_bottom($args){ 
            
            $args = wp_parse_args( $args, array(
                'meal_id'   =>  get_the_ID(),
                'number'  => '',
                'total_meals' => '',
                'step' => '',
                'reset_datas' => false,
                'data_ajax' => ''
            ) );
   
            extract( $args );
            
            $meals_nedd = $number - $total_meals;
            
            if($step == 'add_ons') {
                
            if($meals_nedd > 0) {
                
                  echo '<a href="'.get_the_permalink().'">'.esc_html__('Please choose enough meals to be able to continue','feedy').'</a>';
         
                 return;
            };    
            
            $data = $this->get_meals_data($args);  
       
              $config = $this->jws_nutrition_data_config();
              $meal_nu_ar =  array(
                        'nutrition_cabs' , 'nutrition_protein' , 'nutrition_fat'
              );
                   ?>
                     <span class="point_pro">
                        
                       <svg
                           class="progress-ring"
                           width="80"
                           height="80">
                          <circle 
                            class="progress-ring__circle"
                            stroke="white"
                            stroke-width="5"
                            fill="transparent"
                            r="10.5"
                            cx="12.5"
                            cy="12.5"/>
                        </svg>
                        <div class="point-inner">
                        <span class="count">
                               <?php $itemsQty = array_column($data['total_nu'], 'nutrition_calories');  echo array_sum($itemsQty);  ?>
                        </span>
                         <?php 
                          
                           echo esc_html($config['nutrition_calories']['unit']);
                         
                         ?>
                        
                        </div>
                 
                 </span>
                 
                 <div class="meals-nutrition">
                   
                  
                   <ul class="reset_ul_ol">
                     <?php
                          
                          foreach($meal_nu_ar as $meal_nu) {
                             
                             ?>
                               
                               
                                   <li>
                                        <span class="count">
                                           <?php $itemsQty = array_column($data['total_nu'], $meal_nu);  echo array_sum($itemsQty);  ?>
                                        </span>
                                        <?php echo esc_html($config[$meal_nu]['frontend_label']); ?>
                                     </li>
                             
                             
                             <?php
                            
                            
                          }
                     
                     
                      ?>
     
                   </ul>
                 
                 </div>
                 <a href="<?php echo add_query_arg( 'step', 'add_ons' , get_the_permalink($meal_id) ); ?>" class="proceed_to_checkout meals-button">
                   <span>
                    <?php echo wc_price($data['total_price']); ?>
                    <?php echo esc_html__('Proceed to checkout','feedy'); ?>
                   </span>
                 </a>
                
                <?php
                
            } else {
          
                ?>
    
                <div class="total-meals">
               
                      <?php 
                        
                       printf(
                            '<span class="current">%s</span>/<span class="total">%s</span> %s',
                            $total_meals,
                            $number,
                            esc_html__('Meals','feedy')
                      );
                      
                      ?>
                 
                </div>
                <a href="<?php echo add_query_arg( 'step', 'add_ons' , get_the_permalink($meal_id) ); ?>" class="next meals-button"><?php echo esc_html__('Next','feedy'); ?></a>
                <p class="meals-need">
                  <?php
    
                      if($meals_nedd > 0) {
                             printf(
                                __('Add  %s meals to continue.', 'feedy'),
                                '<span>'.$meals_nedd.'</span>'
                          );
                      } else {
                         
                         echo esc_html__('Completed','feedy');
      
                      }
           
                   ?>
                </p>
    
                <?php
                
            }
    
            if($meals_nedd == 0) { 
               echo '<input name="step-completed" type="hidden" value="true">';  
            }
            
  
        } 

        
        public function cart_add_ons($datas) {
          
                    ?>
                    
                     <div class="cart-add-ons">
                         
                         <div class="addons-top"><span><?php echo esc_html__('Add-Ons','feedy'); ?></span></div>
                     
                         <div class="addons-list">
                            <?php 
                            
                            
                                 if(isset($datas['add_ons'])) {
                                        
                                        $meals_data = $datas['add_ons'];
                              
                                         
                                        foreach($meals_data as $product_id => $qty) {
                                         
                                             get_template_part(    
                                                  'template-parts/content/meals/single/cart-item', '' , array('product_id'=>$product_id,'qty' => $qty , 'show_qty' => true )
                                             );
                        
                                            
                                        }
                                        
                                  } else {  
                                    
                                    ?>
                                    
                                     
                                     <div class="addons-empty">
                                         <?php echo esc_html__('Add a little extra awesomeness to your week.','feedy'); ?>
                                    </div>
                         
                                     
                                    
                                    <?php
                                    
                                    
                                  }
                            
                            
                            ?>
                            
                         
                         </div> 
       
                     </div>
    
                    
                    <?php
              
            
       
        }
        
        public function meals_carts($args){ 
            
            $args = wp_parse_args( $args, array(
                'meal_id'   =>  get_the_ID(),
                'data_ajax'  => '',
                'reset_datas' => false,
                'step' => '',
                'show_qty' => true
            ) );
            extract( $args );
         
            $step = isset($_GET['step']) && $_GET['step'] == 'add_ons' ? 'add_ons' : $step;
       
            $number = $this->number_meals($meal_id);
            
            $datas = $this->get_meals_data($args);
            $total_meals = 0;
           
            $start = 1;
            
            if($step == 'add_ons') { 

                $show_qty = false;
                
            }
            
            $total_nu = array();
            ?>
            
            
            <div class="my-meals-cart">
              
              <div class="cart-top">
               
               <div class="heading">
                  <?php echo esc_html__('My shopping cart','feedy'); ?>
               </div>
               
               <a href="#" class="meals-clear-all"><?php echo esc_html__('Clear all','feedy'); ?></a>
               
              </div>
              
              <div class="cart-center jws-scrollbar">
               
               <?php 
                
                
                if(isset($datas['meals'])) {
                    
                    $meals_data = $datas['meals'];
              
                    $total_meals = 0;
                    
                    if(count($meals_data) > $number) {
                        $start = count($meals_data);
                    }else {
                        $start = count($meals_data) + 1;
                    }
                    
            
                        
                    foreach($meals_data as $product_id => $qty) {
                        
                        $total_meals += $qty;

                         get_template_part(    
                              'template-parts/content/meals/single/cart-item', '' , array('product_id'=>$product_id,'qty' => $qty , 'show_qty' => $show_qty )
                         );
                         
                     
                    }                    
                 
                    
                  
                       
                }
                
             
                
                if(!empty($number) && $step != 'add_ons') {
                    
                    for($i = $start ; $i <= $number ; $i++) {
                        
                        ?> 
                        
                        
                        <div class="meals-product-item empty">
                          
                          <div class="images"><span></span></div>
                          <h6 class="title"><?php echo esc_html__('Meal','feedy').' '.$i; ?></h6>
                        
                        </div>
                        
                        
                        <?php
                        
                    }
                    
                }
                
                     
                if($step == 'add_ons') { 
                    
                    $this->cart_add_ons($datas);
      
                }

               
               ?>
              
              </div>
       
              <div class="cart-bottom">
               
               <?php 
               
                 $this->meals_carts_bottom( array('number' => $number,'total_meals' => $total_meals , 'meal_id' => $meal_id , 'step' => $step , 'data_ajax' => $data_ajax));

               ?>
              
              </div>

            </div>

            <?php
  
        }
        
        public static  function get_nutrition_list() {
    		global /** @var WC_Product $product */
    		$product;
    
    		$nutrition_list = array();
    		foreach ( JwsMeals::jws_nutrition_data_config() as $field_name => $data ) {
    			$meta_value = $product->get_meta( '_' . $field_name );
    			if ( trim( $meta_value ) !== '' ) {
    				$nutrition_list[ $field_name ] = $meta_value;
    			}
    		}
    
    		return $nutrition_list;
    	}
        
        
       public static function jws_nutrition_data_config() { 
            
              $data_config = array(
              
                'nutrition_calories'  => array(
            		'label'                 => esc_html__( 'Energy', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Energy', 'feedy' ),
            		'unit' => 'Cal',
            		'placeholder'           => '500',
            	),
                
                'nutrition_cabs'  => array(
            		'label'                 => esc_html__( 'Carbohydrates', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Cabs', 'feedy' ),
            		'unit' => esc_html__( 'g', 'feedy' ),
            		'placeholder'           => '40',
            	),
                
                'nutrition_fat'  => array(
            		'label'                 => esc_html__( 'Total Fat', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Total Fat', 'feedy' ),
            		'unit' => esc_html__( 'g', 'feedy' ),
            		'placeholder'           => '25',
            	),
                
                'nutrition_protein'  => array(
            		'label'                 => esc_html__( 'Protein', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Protein', 'feedy' ),
            		'unit' => esc_html__( 'g', 'feedy' ),
            		'placeholder'           => '25',
            	),
                
                'saturated_fat'  => array(
            		'label'                 => esc_html__( 'Saturated Fat', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Saturated Fat', 'feedy' ),
            		'unit' => esc_html__( 'g', 'feedy' ),
            		'placeholder'           => '31',
            	),
                
                'sugars'  => array(
            		'label'                 => esc_html__( 'Sugars', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Sugars', 'feedy' ),
            		'unit' => esc_html__( 'g', 'feedy' ),
            		'placeholder'           => '33',
            	),
                
                'sodium'  => array(
            		'label'                 => esc_html__( 'Sodium', 'feedy' ),
            		'frontend_label'        => esc_html__( 'Sodium', 'feedy' ),
            		'unit' => esc_html__( 'mg', 'feedy' ),
            		'placeholder'           => '570',
            	),
              
              
              );
            
              $data_config = apply_filters( 'jws_meals/filter/nutrition_config', $data_config );
              
              return $data_config;
            
        }
        
        
        public function reset_meals_to_cart() {
            
            $message = $_POST;
            $key_cookies = 'meals_'.$_POST['meals'];
            $products = array();
     
          
            setcookie( $key_cookies , json_encode( $products ), 0, COOKIEPATH, COOKIE_DOMAIN, false, false );
            ob_start();
            do_action('jws_meals/meals_carts', array('meal_id'=>$_POST['meals'],'reset_datas' => true ));
            $cart_result = ob_get_clean();
     
           wp_send_json_success(compact( 'message' , 'cart_result' )); 
            
        }
        
         public function change_meals_quanlity_cart() {
              
             $this->add_meals_to_cart();
           
            
        }
        
        
        public function add_meals() { 
           $errors = new WP_Error(); 
           $meals = array();
           $message = '';
           $number = $this->number_meals($_POST['meals']);
           $key_cookies = 'meals_'.$_POST['meals'];
           if(isset($_COOKIE[$key_cookies])) {
                
                 $cookie = json_decode( wp_unslash( $_COOKIE[$key_cookies] ), true ) ;
      
                 if(isset($cookie['meals'])) {
                    
                     $meals =  $cookie['meals'];
    
                 }  
            }
            
            if($_POST['step'] == 'add_ons') {
                return $meals;
            }
            
            $total = array_sum($meals);
            

            if($total >= $number) {
                
                $message = esc_html__( 'Added enough meals.', 'feedy' );
                 
                $errors->add( 
    				'full_meals', 
    				esc_html__( 'Added enough meals.', 'feedy' ) 
    			);

                
            } else {
                
                if (array_key_exists($_POST['id'], $meals)) {
                
                    $meals[$_POST['id']] =  $meals[$_POST['id']] + 1;
                 } 
                 else {
           
                      $meals[$_POST['id']] = 1;
               
                 }

            }
              
            if(isset($_POST['qty'])) {
                
                    if($total >= $number && $meals[$_POST['id']] < $_POST['qty'] ) { 
                        
                        $meals[$_POST['id']] = $meals[$_POST['id']];  
              
                    }  else {
                        
                        $meals[$_POST['id']] =  $_POST['qty'];
                        $errors->remove( 'full_meals' );
                        
                    }
                    
                    if($_POST['qty'] < 1) {
                        
                        unset($meals[$_POST['id']]);
                   
                    }   
             }
             
             if( $errors->get_error_code() ){
                 wp_send_json_error( $errors );
            } 
     
      
             return $meals;      

   
        }
        
        public function add_addons() {  
            
           $add_ons = array();
           $key_cookies = 'meals_'.$_POST['meals']; 
           if(isset($_COOKIE[$key_cookies])) {
                
                 $cookie = json_decode( wp_unslash( $_COOKIE[$key_cookies] ), true ) ;
      
                 if(isset($cookie['add_ons'])) {
                    
                     $add_ons =  $cookie['add_ons'];
    
                 }  
            }
            
            if($_POST['step'] != 'add_ons') {
                return $add_ons;
            }
            


            if (array_key_exists($_POST['id'], $add_ons)) {
                
                 $add_ons[$_POST['id']] =  $add_ons[$_POST['id']] + 1;
            } 
            else {
           
                $add_ons[$_POST['id']] = 1;
               
           }

              
            if(isset($_POST['qty'])) {
             
                    $add_ons[$_POST['id']] =  $_POST['qty'];
              
                    if($_POST['qty'] < 1) {
                        
                        unset($add_ons[$_POST['id']]);
                   
                    }   
             }
     
      
             return $add_ons;      
            
        }
        
        public function add_meals_to_cart() {
  
            $key_cookies = 'meals_'.$_POST['meals'];
            $total_nu = array();
            $message = '';
            
            $meals = $this->add_meals();
            $add_ons = $this->add_addons();
            
            $products = array(
               'meals' => $meals,
               'add_ons' => $add_ons
            );
            
            
            
            $nutritions = JwsMeals::jws_nutrition_data_config();
            
            $finalPrice = get_post_meta( $_POST['meals']  , 'price' , true);
            
            if(!empty($meals)) {
                
                foreach($meals as $product_id => $qty) {
                     
                      foreach($nutritions as $key => $nutrition) {
                   
                       $meata =  get_post_meta( $product_id , '_'.$key, true );
                       if(!empty($meata)) {
                           $nu[$key] = $meata * $qty; 
                       }else {
                        
                        $nu[$key] = ''; 
        
                       }
                    }
                    
                    $total_nu[] = $nu;
                         
                }
                
            }
            
            if(!empty($add_ons)) { 
                
                 foreach($add_ons as $product_id => $qty) {
                    $product = wc_get_product( $product_id );
                    $price_html = $product->get_price(); //It will return a string
                    $finalPrice = (floatval($price_html) * $qty + floatval($finalPrice)); //Float
                 
                      foreach($nutritions as $key => $nutrition) {
                   
                       $meata =  get_post_meta( $product_id , '_'.$key, true );
                       
                       if(!empty($meata)) {
                           $nu[$key] = $meata * $qty; 
                       }else {
                        
                        $nu[$key] = ''; 
        
                       }
                    }
                    
                    $total_nu[] = $nu;
                         
                }   
                
            }

            
            
            $products['total_nu'] = $total_nu;
            $products['total_price'] = $finalPrice;
            
             if(isset($_COOKIE[$key_cookies])) {
                
                 $cookie = json_decode( wp_unslash( $_COOKIE[$key_cookies] ), true ) ;
      
                 if(isset($cookie['cart_key'])) {
                    
                   $products['cart_key'] = $cookie['cart_key'];
    
                 }  
            }
            
          
           setcookie( $key_cookies , json_encode( $products ), 0, COOKIEPATH, COOKIE_DOMAIN, false, false );
   
           ob_start();
           do_action('jws_meals/meals_carts', array('meal_id'=>$_POST['meals'],'data_ajax' => $products , 'step' => $_POST['step'] ));
           $cart_result = ob_get_clean();

           wp_send_json_success(compact( 'message' , 'products' , 'cart_result' )); 
            
        }
        
        
        public function meal_detail() { 
     
           	if( isset($_POST['id']) ) {
    			$id = (int) $_POST['id'];
    		}
    
    
    		global $post, $product;
    
    
    		$args = array( 'post__in' => array($id), 'post_type' => 'product' );
    
    		$quick_posts = get_posts( $args );
    
    	    ob_start();
    
    		foreach( $quick_posts as $post ) :
    			setup_postdata($post);
    			$product = wc_get_product($post);
                get_template_part(    
                   'template-parts/content/meals/single/detail-content', '' , ''
               );
    		endforeach; 
            
            $content = ob_get_clean();
    
    		wp_reset_postdata(); 

            wp_send_json_success(compact( 'content' )); 
            
        }



	}

	new JwsMeals();

}
