<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
} 

/* Add Meals To Woocommerce */


if ( class_exists('WC_Product_Data_Store_CPT') && !class_exists('Jws_Product_Data_Store_CPT')) {

class Jws_Product_Data_Store_CPT extends WC_Product_Data_Store_CPT implements WC_Object_Data_Store_Interface, WC_Product_Data_Store_Interface {


    public function read( &$product ) {

         $product->set_defaults();

        if ( !$product->get_id() || !( $post_object = get_post( $product->get_id() ) ) || !in_array( $post_object->post_type, ['meals', 'product'] ) ) {
            throw new Exception( esc_html__( 'Invalid product.', 'feedy' ) );
        }

    // $id = $product->get_id();

        $product->set_id( $post_object->ID );
        
        $product->set_props( [
            'product_id'        => $post_object->ID,
            'name'              => $post_object->post_title,
            'slug'              => $post_object->post_name,
            'date_created'      => 0 < $post_object->post_date_gmt ? wc_string_to_timestamp( $post_object->post_date_gmt ) : null,
            'date_modified'     => 0 < $post_object->post_modified_gmt ? wc_string_to_timestamp( $post_object->post_modified_gmt ) : null,
            'status'            => $post_object->post_status,
            'description'       => $post_object->post_content,
            'short_description' => $post_object->post_excerpt,
            'parent_id'         => $post_object->post_parent,
            'menu_order'        => $post_object->menu_order,
            'reviews_allowed'   => 'open' === $post_object->comment_status,
        ] );

        $this->read_attributes( $product );
        $this->read_downloads( $product );
        $this->read_visibility( $product );
        $this->read_product_data( $product );
        $this->read_extra_data( $product );
        $product->set_object_read( true );
    }

 
}

	add_filter( 'woocommerce_data_stores', 'jws_woocommerce_data_stores' );
	function jws_woocommerce_data_stores ( $stores ) {   
	   
	      $stores['product'] = 'Jws_Product_Data_Store_CPT';
	      return $stores;
	}
}


add_filter('woocommerce_product_get_price', 'jws_cpt_woocommerce_product_get_price', 10, 2 );

function jws_cpt_woocommerce_product_get_price( $price, $product ) {

    $product_id = $product->get_id();

    if ( get_post_type( $product_id ) == 'meals' && !is_cart() && !is_checkout()) {
        $price = get_post_meta( $product_id, 'price', true );
        $price = isset( $price ) ? $price : 0;
    }

    return $price;
}


// Set insurance price from custom cart item data
add_action( 'woocommerce_before_calculate_totals', 'jws_set_insurance_price' );
function jws_set_insurance_price( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
       return;

    foreach ( $cart->get_cart() as $cart_item ) {

        if( isset($cart_item['insurance_price']) && $cart_item['insurance_price'] > 0 ) {
            $cart_item['data']->set_price( $cart_item['insurance_price'] );
        }
    }
}


if ( class_exists( 'WC_Deposits' ) ) {
     add_action( 'woocommerce_cart_loaded_from_session', 'jws_set_insurance_price', 98, 1 );
}


add_action( 'woocommerce_checkout_create_order_line_item','jws_add_customize_items_data_to_order', 10, 4 );
 
function jws_add_customize_items_data_to_order($item, $cart_item_key, $values, $order) { 
  
    foreach( $item as $cart_item_key=>$values ) {   
        
   
   if( isset( $values['meal_data'] ) ) {
   
     
   ob_start();

        
        ?> 
        
        <div class="jws-dropdown-wap">
 
        <div class="dropdown"> 
  
        <?php
       
		if(isset($values['meal_data']['meals'])) {
			
             ?>
                
             <div class="label"><?php echo esc_html__('Meals','feedy'); ?></div>
            
             <?php
             
    			foreach ( $values['meal_data']['meals'] as $key => $name ) {
    			    
                    $product = wc_get_product( $key );
                    $price_html = $product->get_price(); //It will return a string
                    
    				echo '<div class="item">'.get_the_title($key).' '.wc_price($price_html).' x '.$name.'</div>';
      
    			}  
            
            ?>

            <?php    
      
		 }
         
         if(isset($values['meal_data']['add_ons'])) {

             ?>
             <div class="label"><?php echo esc_html__('Addons','feedy'); ?></div>
             <?php
             
    			foreach ( $values['meal_data']['add_ons'] as $key => $name ) {
    			    
                    $product = wc_get_product( $key );
                    $price_html = $product->get_price(); //It will return a string
                    
    				echo '<div class="item">'.get_the_title($key).' '.wc_price($price_html).' x '.$name.'</div>';
      
    			}  
            
            ?>
      
            <?php  
 
		}
        
        ?> 
        
        </div>
        
        </div> 
         
        <?php
       
        $result = ob_get_clean();
       
    
   }
   if( isset( $result ) && !empty($result) ) {
        $item->add_meta_data( __( 'Meals List', 'feedy' ), $result , true );
        $item->update_meta_data( 'meal_data', $values['meal_data'] );
        return;
    }
    
   }  
} 

function kia_woocommerce_order_item_name( $name, $item ){

    
    if(isset($item['meal_id'])) {
  
    $name = '<a href="'.get_the_permalink($item['meal_id']).'">'.get_the_title($item['meal_id']).'</a>';
    
   }

    return $name;
}
add_filter( 'woocommerce_order_item_name', 'kia_woocommerce_order_item_name', 10, 2 );



function woocommerce_admin_order_item_types( $image , $item_id , $item){
$meta_data = $item->get_meta_data();
   $item_meta_data_to_set = array();
  
	foreach ( $meta_data as $item_meta ) {
	   if($item_meta->key == 'meal_data') {
	        if(isset($item_meta->value['meal_id'])) {
	            $item->set_name(get_the_title($item_meta->value['meal_id']));
                $image = get_the_post_thumbnail( $item_meta->value['meal_id'], 'thumbnail', array( 'class' => '' ) );
	        }
 
	   }   
	
	}
    
          
       
  
       $product_id =  $item->get_product_id();
       $product = wc_get_product($product_id);
       $product_type = $product->get_type();
       
       $stamp       = $item->get_meta( '_stamp', true );
    
       if($product_type == 'bundle') {
        if ( isset( $stamp ) ) { 
            $stamp = array_values($stamp);
            $variation_image = '<div class="half-half-image"><div>';
            foreach($stamp as $key => $cart_com) {
                if(isset($cart_com['variation_id'])) {
                    $variation = wc_get_product($cart_com['variation_id']);
                    if ($variation) {
                        // Get the variation image
                        $thumbnail_id = $variation->get_image_id(); 
                        $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                        $variation_image .= '<div class="pizza-'.$key.'" style="background: url('.$thumbnail_url.')"></div>';
                     
                    }
                }
           
            }
            $variation_image .= '</div></div>';
            $image = $variation_image;
        }

        
        
       }


 return $image;
 
}
add_filter( 'woocommerce_admin_order_item_thumbnail', 'woocommerce_admin_order_item_types', 10, 3 );





add_filter( 'woocommerce_get_item_data',  'get_item_data', 10, 2 );

	 function get_item_data( $other_data, $cart_item ) {

        if(isset($cart_item['meal_id'])) :
        
        ob_start();

        
        ?> 
        
        <div class="jws-dropdown-wap">
        
        <a href="#"><?php echo esc_html__('Show meals','feedy') ?></a>
        
        <div class="dropdown hide"> 
  
        <?php
       
		if(isset($cart_item['meal_data']['meals'])) {
			
             ?>
                
             <div class="label"><?php echo esc_html__('Meals','feedy'); ?></div>
            
             <?php
             
    			foreach ( $cart_item['meal_data']['meals'] as $key => $name ) {
    			    
                    $product = wc_get_product( $key );
                    $price_html = $product->get_price(); //It will return a string
                    
    				echo '<div class="item">'.get_the_title($key).' '.wc_price($price_html).' x '.$name.'</div>';
      
    			}  
            
            ?>

            <?php    
      
		 }
         
         if(isset($cart_item['meal_data']['add_ons'])) {

             ?>
             <div class="label"><?php echo esc_html__('Addons','feedy'); ?></div>
             <?php
             
    			foreach ( $cart_item['meal_data']['add_ons'] as $key => $name ) {
    			    
                    $product = wc_get_product( $key );
                    $price_html = $product->get_price(); //It will return a string
                    
    				echo '<div class="item">'.get_the_title($key).' '.wc_price($price_html).' x '.$name.'</div>';
      
    			}  
            
            ?>
      
            <?php  
 
		}
        
        ?> </div> </div> <?php
 
       
            ?>
              <a class="edit-meals" data-meal="<?php echo esc_attr($cart_item['meal_id']); ?>" data-cart="<?php echo esc_attr($cart_item['key']); ?>" href="#"><?php echo esc_html__('Edit Meals','feedy'); ?></a>
            <?php
       
        $result = ob_get_clean();
            
        $other_data[] = array(
			'name'    => 'hidden',
	        'value'    => $result,
		); 
        
         endif;
        
        
		return $other_data;
	}
    
    
    
function custom_new_product_image($image_id ,$cart_item, $cart_item_key) {

 if(isset($cart_item['meal_id'])) {
  
    $image_id = wp_get_attachment_image(get_post_thumbnail_id((int) $cart_item['meal_id']), 'thumbnail');
    
 }
 
   $product_id = $cart_item['product_id'];
   $product = wc_get_product($product_id);
   $product_type = $product->get_type();

   if($product_type == 'bundle') {
    
    if ( isset( $cart_item[ 'stamp' ] ) ) { 
        $stamp = array_values($cart_item[ 'stamp' ] );
        echo '<div class="half-half-image"><div>';
        foreach($stamp as $key => $cart_com) {
      
            if(isset($cart_com['variation_id'])) {
                $variation = wc_get_product($cart_com['variation_id']);
              
                if ($variation) {
             
                    $thumbnail_id = $variation->get_image_id(); 
                    $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                    echo '<div class="pizza-'.$key.'" style="background: url('.$thumbnail_url.')"></div>';
                }
              
            }
            
       
          $image_id = '';
        }
        echo '</div></div>';
    }
    
   }
 
 return $image_id;
}

add_filter( 'woocommerce_cart_item_thumbnail', 'custom_new_product_image' , 10, 3 );

function custom_new_product_name($name ,$cart_item, $cart_item_key) {

   
 if(isset($cart_item['meal_id'])) {
  
    $name = '<a href="'.get_the_permalink($cart_item['meal_id']).'">'.get_the_title($cart_item['meal_id']).'</a>';
    
 }
 
 return $name;
 
}

add_filter( 'woocommerce_cart_item_name', 'custom_new_product_name' , 10, 3 );

add_filter( 'woocommerce_cart_item_permalink', 'custom_new_product_permalink' , 10, 3 );

function custom_new_product_permalink($link ,$cart_item, $cart_item_key) {

 if(isset($cart_item['meal_id'])) {
  
   $link = get_the_permalink($cart_item['meal_id']);
 }
 
 return $link;
 
}

add_filter( 'woocommerce_order_item_name', 'wp_kama_woocommerce_order_item_name_filter', 10, 3 );

function wp_kama_woocommerce_order_item_name_filter( $name, $item, $false ){

	if(isset($item['meal_data']['meal_id'])) {
	   
        $name = '<a href="'.get_the_permalink($item['meal_data']['meal_id']).'">'.get_the_title($item['meal_data']['meal_id']).'</a>';
 
	}
	return $name;
}

