<?php

namespace Elementor;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;

if (class_exists('WooCommerce')):
    final class JwsProductAdvanced extends Widget_Base
    {
        /**
         * @return string
         */
        function get_name()
        {
            return 'jws-product-advanced';
        }

        /**
         * @return string
         */
        function get_title()
        {
            return esc_html__('Jws Product Advanced', 'feedy');
        }

        /**
         * @return string
         */
        function get_icon()
        {
            return 'eicon-products';
        }
        /**
         * @return array
         */
        public function get_categories()
        {
            return ['jws-elements'];
        }
        public function get_script_depends() {
            
		return ['jws-woocommerce'];
        
	   } 
    
        /**
         * Register controls
         */
        protected function register_controls()
        {
            $this->start_controls_section(
                'section_setting', [
                'label' => esc_html__('Setting', 'feedy')
            ]);

            $this->add_control('layout', [
                'label' => esc_html__('Layout', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => esc_html__('Grid', 'feedy'),
                    'metro' => esc_html__('Metro', 'feedy'),
                    'carousel' => esc_html__('Carousel', 'feedy'),
                ],
            ]);
            
            $this->add_control('display', [
                'label' => esc_html__('Display', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout1',
                'options' => [
                    'layout1' => esc_html__('Layout 1', 'feedy'),
                    'layout2' => esc_html__('Layout 2', 'feedy'),
                    'layout3' => esc_html__('Layout 3', 'feedy'),
                    'layout4' => esc_html__('Layout 4 (No Image)', 'feedy'),
                    'product-deal' => esc_html__('Layout Product Deal', 'feedy'),
                ],
            ]);

            $this->add_control('tabs_filter', [
                'label' => esc_html__('Filter', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'feedy'),
                    'cate' => esc_html__('Category', 'feedy'),
                    'asset' => esc_html__('Asset type', 'feedy'),
                ],

            ]);
            
            $this->add_control('tabs_filter_display', [
                'label' => esc_html__('Filter Display', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal' => esc_html__('Horizontal', 'feedy'),
                    'vertical' => esc_html__('Vertical', 'feedy'),
                ],
                'condition' => [
                    'tabs_filter!' => ['none'],
                ],
            ]);
            $this->add_control('show_text_starting', [
                'label' => esc_html__('Show Text Before Price', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
            ]);
           
            
             $this->add_control(
				'excerpt_length',
				[
					'label'     => esc_html__( 'Excerpt Length', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => '',
				]
			);
             $this->add_control(
				'excerpt_more',
				[
					'label'     => esc_html__( 'Excerpt More', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => ' ... ',
				]
			);
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_readmore', [
                'label' => esc_html__('Read More', 'feedy'),
                'condition' => [
                    'tabs_filter_display' => ['vertical'],
                ],
            ]);
            
             $this->add_control(
    				'readmore',
    				[
    					'label'     => esc_html__( 'Read More', 'feedy' ),
    					'type'      => Controls_Manager::TEXT,
    					'default'   => 'Create your Jewelry',
    				]
    		);
        
            $this->add_control(
    			'readmore_url',
    			[
    				'label' => esc_html__( 'Link', 'feedy' ),
    				'type' => \Elementor\Controls_Manager::URL,
    				'placeholder' => esc_html__( 'https://your-link.com', 'feedy' ),
    				'show_external' => true,
    				'default' => [
    					'url' => '#',
    				],
    			]
    		);
            $this->end_controls_section();

            $this->start_controls_section(
                'section_options', [
                'label' => esc_html__('Options', 'feedy')
            ]);
            //Cate
            $this->add_control('filter_categories', [
                'label' => esc_html__('Categories', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => true,
                'options' => $this->get_categories_for_jws('product_cat', 2),
                'condition' => [
                    'tabs_filter' => ['none', 'cate'],
                ],
            ]);
            $this->add_control('default_category', [
                'label' => esc_html__('Default categories', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $this->get_categories_for_jws('product_cat'),
                'condition' => [
                    'tabs_filter' => 'cate',
                ],
            ]);

            $this->add_control('asset_type', [
                'label' => esc_html__('Asset type', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'all',
                'options' => $this->get_woo_asset_type_for_jws(),
                'condition' => [
                    'tabs_filter' => ['none', 'cate'],
                ],
            ]);

            // Asset
            $this->add_control('filter_assets', [
                'label' => esc_html__('Asset type', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => true,
                'options' => $this->get_woo_asset_type_for_jws(2),
                'condition' => [
                    'tabs_filter' => 'asset',
                ],
            ]);
            $this->add_control('default_asset', [
                'label' => esc_html__('Default asset', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $this->get_woo_asset_type_for_jws(),
                'condition' => [
                    'tabs_filter' => 'asset',
                ],
            ]);
            $this->add_control('filter_categories_for_asset', [
                'label' => esc_html__('Categories', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => true,
                'options' => $this->get_categories_for_jws('product_cat', 2),
                'condition' => [
                    'tabs_filter' => 'asset',
                ],
            ]);

            // Filter default
            $this->add_control('ex_product_ids', [
                'label' => esc_html__('Exclude product IDs', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_list_posts('product'),
            ]);
            $this->add_control('inc_product_ids', [
                'label' => esc_html__('Include product IDs', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_list_posts('product'),
            ]);
            $this->add_control('orderby', [
                'label' => esc_html__('Order by', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => $this->get_woo_order_by_for_jws(),
            ]);
            $this->add_control('order', [
                'label' => esc_html__('Order', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => $this->get_woo_order_for_jws(),
            ]);

            $this->add_control('posts_per_page', [
                'label' => esc_html__('Products per pages', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]);
            // Grid
            $this->add_responsive_control('columns', [
                'label' => esc_html__('Columns for row', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => esc_html__('12', 'feedy'),
                    '2' => esc_html__('6', 'feedy'),
                    '3' => esc_html__('4', 'feedy'),
                    '4' => esc_html__('3', 'feedy'),
                    '6' => esc_html__('2', 'feedy'),
                    '12' => esc_html__('1', 'feedy'),
                    '20' => esc_html__('5', 'feedy'),
                    '2' => esc_html__('6', 'feedy'),
                ],

            ]);

            $this->add_control('pagination', [
                'label' => esc_html__('Pagination', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'feedy'),
                    'numeric' => esc_html__('Numeric', 'feedy'),
                    'ajaxload' => esc_html__('Ajax Load More', 'feedy'),
                ],
                'condition' => [
                    'layout!' => 'carousel',
                    'tabs_filter' => 'none',
                ],
            ]);
            // Carousel
            $this->add_responsive_control('slides_to_show', [
                'label' => esc_html__('Slides to Show', 'feedy'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                    ]
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'condition' => [
                    'layout' => 'carousel',
                ],

            ]);
            
            
             $this->add_control(
    			'enble_muntirow',
    			[
    				'label'        => esc_html__( 'Enble Munti row', 'feedy' ),
    				'type'         => Controls_Manager::SWITCHER,
    				'return_value' => 'yes',
    				'default'      => '',
                    'condition' => [
                        'layout' => 'carousel',
                    ],
    			]
    		);
            
            $this->add_responsive_control('number_row', [
                'label' => esc_html__('Number Row', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'condition' => [
                    'enble_muntirow' => 'yes',
                ],
            ]);
            
            
            $this->add_responsive_control('number_col_row', [
                'label' => esc_html__('Number Item On Row', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'condition' => [
                    'enble_muntirow' => 'yes',
                ],
            ]);

            $this->add_control('speed', [
                'label' => esc_html__('Carousel: Speed to Scroll', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::NUMBER,
                'default' => 500,
                'condition' => [
                   'layout' => 'carousel',
                 ],

            ]);
            $this->add_control('scroll', [
                'label' => esc_html__('Carousel: Slide to Scroll', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_responsive_control('autoplay', [
                'label' => esc_html__('Carousel: Auto Play', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_responsive_control('center_mode', [
                'label' => esc_html__('Carousel: Center Mode', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
  
            $this->add_responsive_control('infinite', [
                'label' => esc_html__('Carousel: Infinite', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            
             $this->add_responsive_control('center_mode_padding', [
                'label' => esc_html__('Cener Mode Padding', 'feedy'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ]
                ],
                'desktop_default' => [
                    'size' => 220,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 100,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 0,
                    'unit' => 'px',
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'condition' => [
                    'layout' => 'carousel',
                    'center_mode' => 'true',
                ],

            ]);
            
            $this->add_responsive_control('show_pag', [
                'label' => esc_html__('Carousel: Pagination', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_responsive_control('show_nav', [
                'label' => esc_html__('Carousel: Navigation', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            
            $this->add_control('nav_position', [
                'label' => esc_html__('Carousel: Navigation position', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SELECT,
                'default' => 'middle-nav',
                'options' => [
                    'top-nav' => esc_html__('Top', 'feedy'),
                    'middle-nav' => esc_html__('Middle', 'feedy'),
                ],
                'condition' => [
                    'show_nav' => 'true',
                    'layout' => 'carousel',
                ],

            ]);
            
            $this->add_responsive_control(
    			'nav_offset_left',
    			[
    				'label' => esc_html__( 'Nav Offset Left', 'feedy' ),
    				'type' => \Elementor\Controls_Manager::SLIDER,
    				'size_units' => [ 'px', '%' ],
    				'range' => [
    					'px' => [
    						'min' => 0,
    						'max' => 1000,
    						'step' => 5,
    					],
    					'%' => [
    						'min' => 0,
    						'max' => 100,
    					],
    				],
    				'selectors' => [
    					'{{WRAPPER}} .products-tab .jws-nav-carousel .jws-button-prev' => 'left: {{SIZE}}{{UNIT}};',
    				],
    			]
    		);
            
            $this->add_responsive_control(
    			'nav_offset_right',
    			[
    				'label' => esc_html__( 'Nav Offset Right', 'feedy' ),
    				'type' => \Elementor\Controls_Manager::SLIDER,
    				'size_units' => [ 'px', '%' ],
    				'range' => [
    					'px' => [
    						'min' => 0,
    						'max' => 1000,
    						'step' => 5,
    					],
    					'%' => [
    						'min' => 0,
    						'max' => 100,
    					],
    				],
    				'selectors' => [
    					'{{WRAPPER}} .products-tab .jws-nav-carousel .jws-button-next' => 'right: {{SIZE}}{{UNIT}};',
    				],
    			]
    		);
            
            
            
            $this->add_responsive_control('hiden_item_outside', [
                'label' => esc_html__('Carousel Hidden Item Out Side', 'feedy'),
                'description' => esc_html__('', 'feedy'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'feedy'),
                'label_off' => esc_html__('Hide', 'feedy'),
                'return_value' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->end_controls_section();
                         $this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Columns Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product-item' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
					'{{WRAPPER}} .row' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'     => esc_html__( 'Rows Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control('bg_image_color', [
                'label' => esc_html__('Background For Image', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-image' => 'background: {{VALUE}};'
                ]
        ]);
        $this->end_controls_section();
        
           $this->start_controls_section(
                'content_item_style', [
                'label' => esc_html__('Content item style', 'feedy'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);
            
            $this->add_control('item_title_style', [
                'label' => esc_html__('Product name', 'feedy'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]);
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'product_name_ty',
                    'selector' => '{{WRAPPER}} .product-item.product .woocommerce-loop-product__title',
                ]
            );
    
            $this->add_responsive_control(
				'product_name_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'feedy' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .product-item.product .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],

					'separator' => 'before',
				]
		  );
          
          $this->add_control('item_price_style', [
                'label' => esc_html__('Product price', 'feedy'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
          ]);
          
          $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'product_price_ty',
                    'selector' => '{{WRAPPER}} .product-item.product .price',
                ]
          );
          
          $this->add_control(
			'product_price_color',
			[
				'label' => esc_html__( 'Color', 'feedy' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-item.product .price' => 'color: {{VALUE}}',
				],
			]
		 );
         
         $this->add_control('item_des_style', [
                'label' => esc_html__('Product Description', 'feedy'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
          ]);
          
          $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'product_des_ty',
                    'selector' => '{{WRAPPER}} .product-excerpt',
                ]
          );
          
          $this->add_control(
			'product_des_color',
			[
				'label' => esc_html__( 'Color', 'feedy' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-excerpt' => 'color: {{VALUE}}',
				],
			]
		 );

          $this->end_controls_section();
        
            
            
             $this->start_controls_section(
                'pagination_style_settings', [
                'label' => esc_html__('Pagination style', 'feedy'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

            
            $this->add_responsive_control(
    			'pagination_margin',
    			[
    				'label' => esc_html__( 'Margin', 'feedy' ),
    				'type' => Controls_Manager::DIMENSIONS,
    				'size_units' => [ 'px', 'em', '%' ],
    				'selectors' => [
    					'{{WRAPPER}} .jws-products-load-more , {{WRAPPER}} .jws-products-load-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    				],
    			]
    		);


            $this->end_controls_section();
            
            
            $this->start_controls_section(
                'filter_style_settings', [
                'label' => esc_html__('Filter style', 'feedy'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);
            $this->add_responsive_control(
                'filter_align',
                [
                    'label' => esc_html__('Align', 'feedy'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'feedy'),
                            'icon' => 'fa fa-align-left',
                        ], 'center' => [
                            'title' => esc_html__('Center', 'feedy'),
                            'icon' => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'feedy'),
                            'icon' => 'fa fa-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .jws-head-filter' => 'text-align: {{VALUE}};'
                    ]
                ]
            );
            $this->add_responsive_control(
    			'filter_padding',
    			[
    				'label' => esc_html__( 'Padding', 'feedy' ),
    				'type' => Controls_Manager::DIMENSIONS,
    				'size_units' => [ 'px', 'em', '%' ],
    				'selectors' => [
    					'{{WRAPPER}} .jws-head-filter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    				],
    			]
    		);
            $this->add_responsive_control(
    			'filter_margin',
    			[
    				'label' => esc_html__( 'Margin', 'feedy' ),
    				'type' => Controls_Manager::DIMENSIONS,
    				'size_units' => [ 'px', 'em', '%' ],
    				'selectors' => [
    					'{{WRAPPER}} .jws-head-filter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    				],
    			]
    		);
            $this->add_responsive_control(
    			'filter_item_margin',
    			[
    				'label' => esc_html__( 'Item Margin', 'feedy' ),
    				'type' => Controls_Manager::DIMENSIONS,
    				'size_units' => [ 'px', 'em', '%' ],
    				'selectors' => [
    					'{{WRAPPER}} .jws-head-filter .jws-ajax-load li:not(:last-child)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    				],
    			]
    		);
            $this->add_control('filter_color', [
                'label' => esc_html__('Color', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-head-filter a' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_control('filter_active_color', [
                'label' => esc_html__('Active Color', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-head-filter a.active, {{WRAPPER}} .jws-head-filter a:hover' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'filter_typography',
                    'selector' => '{{WRAPPER}} .jws-head-filter a',
                ]
            );

            $this->end_controls_section();
            $this->start_controls_section(
                'carousel_style_settings', [
                'label' => esc_html__('Carousel style', 'feedy'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);
            $this->add_control('arrow_style', [
                'label' => esc_html__('Arrow', 'feedy'),
                'type' => Controls_Manager::HEADING,
            ]);

            $this->add_control('arrow_color', [
                'label' => esc_html__('Color', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel .jws-carousel-btn' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_control('arrow_hover_color', [
                'label' => esc_html__('Hover Color', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel .jws-carousel-btn:hover' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_control('arrow_size', [
                'label' => esc_html__('Size', 'feedy'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel .jws-carousel-btn' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_control('dotted_style', [
                'label' => esc_html__('Dotted', 'feedy'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]);
            $this->add_control('dotted_color', [
                'label' => esc_html__('Color', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li' => 'background: {{VALUE}};'
                ]
            ]);
            $this->add_control('dotted_hover_color', [
                'label' => esc_html__('Hover & Active Color', 'feedy'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li:hover, {{WRAPPER}} .jws-carousel ul.slick-dots li.slick-active' => 'background: {{VALUE}};'
                ]
            ]);
            $this->add_control('dotted_size', [
                'label' => esc_html__('Size', 'feedy'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li.slick-active' => 'width: calc({{SIZE}}{{UNIT}} * 3);',
                ],
            ]);
            $this->add_control('dotted_radius', [
                'label' => esc_html__('Border radius', 'feedy'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li' => 'border-radius: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->end_controls_section();
        }

        /**
         * Retrieve the list of scripts the image carousel widget depended on.
         *
         * Used to set scripts dependencies required to run the widget.
         *
         * @since 1.3.0
         * @access public
         *
         * @return array Widget scripts dependencies.
         */

        protected function get_categories_for_jws($taxonomy, $select = 1)
        {
            $data = array();
    
            $query = new \WP_Term_Query(array(
                'hide_empty' => true,
                'taxonomy'   => $taxonomy,
            ));
            if ($select == 1) {
                $data['all'] = 'All';
            }
    
            if (! empty($query->terms)) {
                foreach ($query->terms as $cat) {
                    $data[ $cat->slug ] = $cat->name;
                }
            }
    
            return $data;
        }
        protected function get_woo_asset_type_for_jws($select = 1)
        {
        if ($select == 1) {
            $asset_type = array(
                'all'          => esc_html__('All', 'feedy'),
                'latest'       => esc_html__('New Arrivals', 'feedy'),
                'featured'     => esc_html__('Featured', 'feedy'),
                'onsale'       => esc_html__('On sale', 'feedy'),
                'deal'         => esc_html__('Deal', 'feedy'),
                'best-selling' => esc_html__('Best Seller', 'feedy'),
                'toprate'      => esc_html__('Top Rate', 'feedy'),
            );
        } else {
            $asset_type = array(
                'latest'       => esc_html__('New Arrivals', 'feedy'),
                'featured'     => esc_html__('Featured', 'feedy'),
                'onsale'       => esc_html__('On sale', 'feedy'),
                'deal'         => esc_html__('Deal', 'feedy'),
                'best-selling' => esc_html__('Best Seller', 'feedy'),
                'toprate'      => esc_html__('Top Rate', 'feedy'),
            );
        }

        return $asset_type;
        }
        protected function get_list_posts($post_type = 'post')
        {
            $args = array(
                'post_type'        => $post_type,
                'suppress_filters' => true,
                'posts_per_page'   => 300,
                'no_found_rows'    => true,
            );
    
            $the_query = new \WP_Query($args);
            $results   = [];
    
            if (is_array($the_query->posts) && count($the_query->posts)) {
                foreach ($the_query->posts as $post) {
                    $results[ $post->ID ] = sanitize_text_field($post->post_title);
                }
            }
    
            return $results;
        }
            /**
     * Get oder by
     *
     * @return array oder_by
     */
    protected function get_woo_order_by_for_jws()
    {
        $order_by = array(
            'date'       => esc_html__('Date', 'feedy'),
            'menu_order' => esc_html__('Menu order', 'feedy'),
            'title'      => esc_html__('Title', 'feedy'),
            'rand'       => esc_html__('Random', 'feedy'),
        );

        return $order_by;
    }

    /**
     * Get oder
     *
     * @return array order
     */
    protected function get_woo_order_for_jws()
    {
        $order = array(
            'desc' => esc_html__('DESC', 'feedy'),
            'asc'  => esc_html__('ASC', 'feedy'),
        );

        return $order;
    }
    
    protected function get_icon_tabs($term_id)
    {
        $attach_id = get_term_meta( $term_id, 'cat_icon', 1 );
        $image = jws_image_advanced(array('attach_id' => $attach_id, 'thumb_size' => 'full'));
        return !empty($image) ? $image : '';

    }
     

        /**
         * Render
         */
        protected function render()
        {
            // default settings
            $settings = array_merge([
                'title' => '',
                'tabs_filter' => 'cate',
                'filter_categories' => '',
                'default_category' => '',
                'asset_type' => 'all',
                'filter_assets' => '',
                'default_asset' => '',
                'product_ids' => '',
                'orderby' => 'date',
                'order' => 'desc',
                'posts_per_page' => 6,
                'columns' => '',
                'pagination' => '',
                'slides_to_show' => 4,
                'speed' => 5000,
                'scroll' => 1,
                'autoplay' => 'true',
                'show_pag' => 'true',
                'show_nav' => 'true',
                'nav_position' => 'middle-nav',
                'excerpt_length' => '',
                'excerpt_more' => '...'
               

            ], $this->get_settings_for_display());

            $this->add_inline_editing_attributes('title');

            $this->add_render_attribute('title', 'class', 'feedyduct-title');

            include 'content.php';
        }
    }
endif;