<?php
namespace Elementor;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Core\Schemes\Typography;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Jws_Price_Table extends Widget_Base {

	public function get_name() {
		return 'jws-price-table';
	}

	public function get_title() {
		return esc_html__( 'Price Table', 'feedy' );
	}

	public function get_icon() {
		return 'eicon-price-table';
	}

	public function get_keywords() {
		return [ 'pricing', 'table', 'product', 'image', 'plan', 'button' ];
	}
    public function get_categories() {
		return [ 'jws-elements' ];
	}

	protected function register_controls() {

       
	
        /** Plan 1 **/
		$this->start_controls_section(
			'section_pricing',
			[
				'label' => esc_html__( 'Pricing', 'feedy' ),
			]
		);

    
        $this->add_control(
			'pricing_title',
			[
				'label' => esc_html__( 'Title', 'feedy' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title', 'feedy' ),
			]
		);
        $this->add_control(
			'pricing_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'feedy' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Sub Title', 'feedy' ),
			]
		);
        $this->add_control(
			'pricing_price',
			[
				'label' => esc_html__( 'Price', 'feedy' ),
				'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '$100', 'feedy' ),
			]
		);
        $this->add_control(
			'pricing_price_after',
			[
				'label' => esc_html__( 'Price After', 'feedy' ),
				'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '/ per day', 'feedy' ),
			]
		);
        
        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'pricing_fr_text', [
				'label' => __( 'Title', 'feedy' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'feedy' ),
				'label_block' => true,
			]
		);
         $repeater->add_control(
			'pricing_fr_active',
			[
				'label' => __( 'Active', 'feedy' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'feedy' ),
				'label_off' => __( 'No', 'feedy' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Feature List Value', 'feedy' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'pricing_fr_text' => __( 'text #1', 'feedy' ),

					],

				],
				'title_field' => '{{{ pricing_fr_text }}}',
			]
		);
        
        $this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button Text', 'feedy' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Read more', 'feedy' ),
			]
		);
       	$this->add_control(
			'button_link',
			[
				'label' => esc_html__( 'Link', 'feedy' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'https://your-link.com', 'feedy' ),
				'default' => [
					'url' => '#',
				],
            
			]
		);
   

        
		$this->end_controls_section();
        
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
   
        $this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Pricing Border Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-header , {{WRAPPER}} .jws-pricing-table' => 'border-color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Pricing Background Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table' => 'background: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-title' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'sub_title_color',
			[
				'label' => esc_html__( 'Sub Title Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-sub-title' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'price_color',
			[
				'label' => esc_html__( 'Price Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-price' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'feature_color',
			[
				'label' => esc_html__( 'Feature Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-features' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'feature_icon_color',
			[
				'label' => esc_html__( 'Feature Icon Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-features li:before' => 'color: {{VALUE}};',
				],
			]
		);
        
        
        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Button Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-link a' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'button_bg',
			[
				'label' => esc_html__( 'Button Background', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-link a' => 'background: {{VALUE}};border-color: {{VALUE}};',
				],
			]
		);
        
         $this->add_control(
			'button_color_hover',
			[
				'label' => esc_html__( 'Button Color', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-link a:hover' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'button_bg_hover',
			[
				'label' => esc_html__( 'Button Background', 'feedy' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .jws-pricing-table .pricing-link a:hover' => 'background: {{VALUE}};order-color: {{VALUE}};',
				],
			]
		);
        
        
        $this->end_controls_section();
       

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
  
        ?>

		<div class="jws-pricing-table">
          
               
               <div class="pricing-header">
                
                     <h3 class="pricing-title">
                        <?php echo esc_html($settings['pricing_title']); ?>
                    </h3>
                    <div class="pricing-sub-title">
                        <?php echo esc_html($settings['pricing_sub_title']); ?>
                    </div>
                    <div class="pricing-price">
                        <?php 
              
                            if(!empty($settings['pricing_price'])) {
                               echo '<span>'.$settings['pricing_price'].'</span>'.$settings['pricing_price_after']; 
                            }
                        ?>
                      
                    </div>
               
               </div>
               <div class="pricing-footer"> 
               <?php 
                    if ( $settings['list'] ) {
            			echo '<ul class="pricing-features reset_ul_ol">';
            			foreach (  $settings['list'] as $fr_item ) {
            			    
                            
                            if($fr_item['pricing_fr_active'] == 'yes') {
                                $active = ' active';
                            }else {
                                $active = '';
                            }
                            
                            echo '<li class="feature'.$active.'">' . $fr_item['pricing_fr_text'] . '</li>';  
    	
            			}
            			echo '</ul>';
            		}
               ?>
               <div class="pricing-link">
                    <?php
                        $this->add_render_attribute( 'wrapper', 'class', ['elementor-button-wrapper'] );
                     	if ( ! empty( $settings['button_link']['url'] ) ) {
                			$this->add_render_attribute( 'button', 'href', $settings['button_link']['url'] );
                			$this->add_render_attribute( 'button', 'class', 'elementor-button-link');
                
                			if ( $settings['button_link']['is_external'] ) {
                				$this->add_render_attribute( 'button', 'target', '_blank' );
                			}
                
                			if ( $settings['button_link']['nofollow'] ) {
                				$this->add_render_attribute( 'button', 'rel', 'nofollow' );
                			}
                		}
                    ?>
                    <a <?php echo ''.$this->get_render_attribute_string( 'button' ); ?>>
        			     <?php echo esc_html($settings['button_text']); ?>    
        			</a>
               </div>
            </div>
		</div>

		<?php
	}

	protected function content_template() {}
}
