<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Jws_meals extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_meals';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws Meals', 'feedy' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-meals';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}
 

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
	    $this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Setting', 'feedy' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
				'meals_layout',
				[
					'label'     => esc_html__( 'Layout', 'feedy' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'layout1',
					'options'   => [
						'layout1'   => esc_html__( 'layout1', 'feedy' ),
                        'layout2'   => esc_html__( 'layout2', 'feedy' ),
					],
                    
				]
		);
        $this->add_control(
				'meals_display',
				[
					'label'     => esc_html__( 'Display', 'feedy' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'grid',
					'options'   => [
						'grid'   => esc_html__( 'Grid', 'feedy' ),
                        'slider'   => esc_html__( 'Slider', 'feedy' ),
					],
                    
				]
		);

        $this->add_responsive_control(
				'meals_columns',
				[
					'label'          => esc_html__( 'Columns', 'feedy' ),
					'type'           => Controls_Manager::SELECT,
					'default'        => '12',
					'options'        => [
						'12' => '1',
						'6' => '2',
						'4' => '3',
						'3' => '4',
						'20' => '5',
						'2' => '6',
					],
				]
		);


        $this->end_controls_section();   
	    $this->start_controls_section(
			'setting_section_list',
			[
				'label' => esc_html__( 'Meals List', 'feedy' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);   
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'feedy' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
         $repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' => 'large',
				'separator' => 'none',
			]
		);
        $repeater->add_control(
				'title',
				[
					'label'     => esc_html__( 'Title', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => '4 Meals',
				]
		);
        
        $repeater->add_control(
				'sub_title',
				[
					'label'     => esc_html__( 'Sub Title', 'feedy' ),
					'type'      => Controls_Manager::TEXTAREA,
					'default'   => 'Per Week',
				]
		);
        
        
        $repeater->add_control(
				'price',
				[
					'label'     => esc_html__( 'Price', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => '$100',
				]
		);
        
        $repeater->add_control(
				'after_price',
				[
					'label'     => esc_html__( 'After Price', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => '/ meal',
				]
		);
        
        
        $repeater->add_control(
				'button_text',
				[
					'label'     => esc_html__( 'Button Text', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => 'Get started',
				]
		);

        $repeater->add_control(
			'link_url',
			[
				'label' => esc_html__( 'Meal Link', 'feedy' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'feedy' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
				],
			]
		);
        
        
        $repeater->add_control(
				'bottom_text',
				[
					'label'     => esc_html__( 'Bottom Text', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => 'Free Shipping',
				]
		);


        $this->add_control(
			'list',
			[
				'label' => esc_html__( 'Meals List', 'feedy' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'meals_title' => esc_html__( 'Meals #1', 'feedy' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Columns Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws-meals .jws-meals-item' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
					'{{WRAPPER}} .jws-meals.row' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'     => esc_html__( 'Rows Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws-meals .jws-meals-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
         $this->add_responsive_control(
			'meals_content_padding',
			[
				'label'      => esc_html__( 'Content Padding', 'feedy' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .jws-meals .jws-meals-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
			'meals_title_style',
			[
				'label' => esc_html__( 'Title', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'meals_title_color',
			[
				'label'     => esc_html__( 'Text Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-meals .title' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'meals_title_typography',
				'label'     => esc_html__( 'Typography', 'feedy' ),
				'selector'  => '{{WRAPPER}} .jws-meals .title',
			]
		);
        
         $this->add_responsive_control(
			'meals_title_margin',
			[
				'label'      => esc_html__( 'Margin', 'feedy' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .jws-meals .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
			'meals_price_style',
			[
				'label' => esc_html__( 'Price', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'meals_price_color',
			[
				'label'     => esc_html__( 'Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-meals .price' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'meals_price_typography',
				'label'     => esc_html__( 'Typography', 'feedy' ),
				'selector'  => '{{WRAPPER}} .jws-meals .price',
			]
		);
        
         $this->add_responsive_control(
			'meals_price_margin',
			[
				'label'      => esc_html__( 'Margin', 'feedy' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .jws-meals .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        
          $this->start_controls_section(
			'meals_button_style',
			[
				'label' => esc_html__( 'Button', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'meals_button_color',
			[
				'label'     => esc_html__( 'Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-meals .view-meals' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'meals_button_bgcolor',
			[
				'label'     => esc_html__( 'Background Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-meals .view-meals' => 'background-color: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'meals_button_color_hover',
			[
				'label'     => esc_html__( 'Color Hover', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-meals .view-meals:hover' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_control(
			'meals_button_bgcolor_hover',
			[
				'label'     => esc_html__( 'Background Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-meals .view-meals:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'meals_button_typography',
				'label'     => esc_html__( 'Typography', 'feedy' ),
				'selector'  => '{{WRAPPER}} .jws-meals .view-meals',
			]
		);
        
        $this->add_responsive_control(
			'meals_button_padding',
			[
				'label'      => esc_html__( 'Padding', 'feedy' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .jws-meals .view-meals' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
         $this->add_responsive_control(
			'meals_button_margin',
			[
				'label'      => esc_html__( 'Margin', 'feedy' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .jws-meals .view-meals' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
         $this->start_controls_section(
			'setting_navigation',
			[
				'label' => esc_html__( 'Setting Slider Navigation', 'feedy' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
				'enable_nav',
				[
					'label'        => esc_html__( 'Enable Nav', 'feedy' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', 'feedy' ),
					'label_off'    => esc_html__( 'No', 'feedy' ),
					'return_value' => 'yes',
					'default'      => 'yes',
					'description'  => esc_html__( 'Enable nav arrow.', 'feedy' ),
				]
    	);
        

        $this->add_control(
    				'enable_dots',
    				[
    					'label'        => esc_html__( 'Enable Dots', 'feedy' ),
    					'type'         => Controls_Manager::SWITCHER,
    					'label_on'     => esc_html__( 'Yes', 'feedy' ),
    					'label_off'    => esc_html__( 'No', 'feedy' ),
    					'return_value' => 'yes',
    					'default'      => '',
    					'description'  => esc_html__( 'Enable dot.', 'feedy' ),
    				]
    	);

    
        $this->end_controls_section();  
           
		$this->start_controls_section(
			'section_slider_options',
			[
				'label'     => esc_html__( 'Slider Options', 'feedy' ),
				'type'      => Controls_Manager::SECTION,
				'condition' => [
					'meals_display' => ['slider'],
				],
			]
		);

		$this->add_responsive_control(
			'slides_to_show',
			[
				'label'          => esc_html__( 'posts to Show', 'feedy' ),
				'type'           => Controls_Manager::NUMBER,
                'condition'    => [
					'variablewidth!'             => 'yes',
				],

			]
		);

		$this->add_responsive_control(
			'slides_to_scroll',
			[
				'label'          => esc_html__( 'posts to Scroll', 'feedy' ),
				'type'           => Controls_Manager::NUMBER,
	
			]
		);
        
		$this->add_control(
			'autoplay',
			[
				'label'        => esc_html__( 'Autoplay', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
		$this->add_control(
			'autoplay_speed',
			[
				'label'     => esc_html__( 'Autoplay Speed', 'feedy' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5000,
				'selectors' => [
					'{{WRAPPER}} .slick-slide-bg' => 'animation-duration: calc({{VALUE}}ms*1.2); transition-duration: calc({{VALUE}}ms)',
				],
				'condition' => [
					'autoplay'             => 'yes',
				],
			]
		);
		$this->add_control(
			'pause_on_hover',
			[
				'label'        => esc_html__( 'Pause on Hover', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'autoplay'             => 'yes',
				],
			]
		);

		$this->add_control(
			'infinite',
			[
				'label'        => esc_html__( 'Infinite Loop', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
        
        
        $this->add_control(
			'variablewidth',
			[
				'label'        => esc_html__( 'variable Width', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
                'default' => 'no'

			]
		);
        
        $this->add_control(
			'center',
			[
				'label'        => esc_html__( 'Cener Mode', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
        
        $this->add_responsive_control(
			'variablewidth_width',
			[
				'label'     => esc_html__( 'Add Width For Item Variable Width (px) ', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px','%'],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					]
				],
		
				'selectors' => [
					'{{WRAPPER}} .jws-meals-inner' => 'width: {{SIZE}}px;',
				],
                'condition'    => [
					'variablewidth'             => 'yes',
				],
			]
		);
        
        $this->add_control(
			'rtl',
			[
				'label'        => esc_html__( 'Right To Left', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
		$this->add_control(
			'transition_speed',
			[
				'label'     => esc_html__( 'Transition Speed (ms)', 'feedy' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 500,
			]
		);
		$this->end_controls_section();
        
      
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
	   
		$settings = $this->get_settings_for_display();
        $class_row = 'jws-meals row '.$settings['meals_layout']; 
 
        $image_size = (!empty($settings['meals_dimension']['width']) || !empty($settings['meals_dimension']['height'])) ? $settings['meals_dimension']['width'].'x'.$settings['meals_dimension']['height'] : 'full';
        
          $class_column = 'jws-meals-item';
          $class_column .= ' col-xl-'.$settings['meals_columns'].'';
          $class_column .= (!empty($settings['meals_columns_tablet'])) ? ' col-lg-'.$settings['meals_columns_tablet'].'' : ' col-lg-'.$settings['meals_columns'].'' ;
          $class_column .= (!empty($settings['meals_columns_mobile'])) ? ' col-'.$settings['meals_columns_mobile'].'' :  ' col-'.$settings['meals_columns'].''; 
          
          $class_row .= ' '.$settings['meals_display'];
          
          if($settings['meals_display'] == 'slider') {
            $class_row .= ' owl-carousel';
            $class_column .= ' slider-item';
            $dots = ($settings['enable_dots'] == 'yes') ? 'true' : 'false';
            $arrows = ($settings['enable_nav'] == 'yes') ? 'true' : 'false';
            $autoplay = ($settings['autoplay'] == 'yes') ? 'true' : 'false';
            $pause_on_hover = ($settings['pause_on_hover'] == 'yes') ? 'true' : 'false';
            $infinite = ($settings['infinite'] == 'yes') ? 'true' : 'false';
            $rtl = ($settings['rtl'] == 'yes') ? 'true' : 'false';
            
            $settings['slides_to_show'] = isset($settings['slides_to_show']) && !empty($settings['slides_to_show']) ? $settings['slides_to_show'] : '3';

            $settings['slides_to_show_tablet'] = isset($settings['slides_to_show_tablet']) && !empty($settings['slides_to_show_tablet']) ? $settings['slides_to_show_tablet'] : $settings['slides_to_show'];
            $settings['slides_to_show_mobile'] = isset($settings['slides_to_show_mobile']) && !empty($settings['slides_to_show_mobile']) ? $settings['slides_to_show_mobile'] : $settings['slides_to_show'];
            
            $variablewidth = ($settings['variablewidth'] == 'yes') ? 'true' : 'false'; 
        
            if($variablewidth == 'true') {
               $settings['slides_to_show']  = $settings['slides_to_show_tablet'] = $settings['slides_to_show_mobile'] = '1';
            }
            
            $center = ($settings['center'] == 'yes') ? 'true' : 'false';
                
            if($center ==  'true') {
                
                $class_row .= ' center-mode';
                
            }
            
            $settings['slides_to_scroll'] = isset($settings['slides_to_scroll']) && !empty($settings['slides_to_scroll']) ? $settings['slides_to_scroll'] : '1';
            
            $settings['slides_to_scroll_tablet'] = isset($settings['slides_to_scroll_tablet']) && !empty($settings['slides_to_scroll_tablet']) ? $settings['slides_to_scroll_tablet'] : $settings['slides_to_scroll'];
            $settings['slides_to_scroll_mobile'] = isset($settings['slides_to_scroll_mobile']) && !empty($settings['slides_to_scroll_mobile']) ? $settings['slides_to_scroll_mobile'] : $settings['slides_to_scroll']; 
            
            
            $autoplay_speed = (isset($settings['autoplay_speed']) &  !empty($settings['autoplay_speed'])) ? $settings['autoplay_speed'] : '5000';
      
            $data_slick = 'data-owl-option=\'{
                "autoplay": '.$autoplay.',
                "nav": '.$arrows.', 
                "dots":'.$dots.', 
                "autoplayTimeout": '.$autoplay_speed.',
                "autoplayHoverPause":'.$pause_on_hover.',
                "loop":'.$infinite.',
                "center":'.$center.', 
                "autoWidth":'.$variablewidth.',
                "smartSpeed": '.$settings['transition_speed'].', 
                "responsive":{
                    "1024":{"items": '.$settings['slides_to_show'].',"slideBy": '.$settings['slides_to_scroll'].'},
                    "768":{"items": '.$settings['slides_to_show_tablet'].',"slideBy": '.$settings['slides_to_scroll_tablet'].'},
                    "0":{"items": '.$settings['slides_to_show_mobile'].',"slideBy": '.$settings['slides_to_scroll_mobile'].'}
            }}\'';  
       }else {
            $data_slick = '';
             
       }

         ?>
         <div class="jws-meals-element">
  
            <div class="<?php echo esc_attr($class_row); ?>"  data-meals="jws-custom-<?php echo esc_attr($this->get_id()); ?>" <?php echo ''.$data_slick; ?>>
               <?php 
                 $i = 1; $n = 0; foreach (  $settings['list'] as $index => $item ) {
                    
             
                   $link_key = 'link' . $index;   
                   if($item['link_url']['is_external']) $this->add_render_attribute( $link_key, 'rel',  'nofollow' );
                   if($item['link_url']['nofollow']) $this->add_render_attribute( $link_key, 'target',  '_blank' );  
                   $this->add_render_attribute( $link_key, 'href',  $item['link_url']['url'] ); 

                    ?>
                        <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> <?php echo esc_attr($class_column); ?>">
                        <?php  include( ''.$settings['meals_layout'].'.php' );  ?>
                   
                    </div>
                <?php $n++; } ?>
            </div>
         </div>   
        <?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}