<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Jws_Gallery extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_gallery';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws Gallery', 'feedy' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}
 
    public function get_tabs_list() { 
        
        global $jws_option;
        
        
        if(isset($jws_option['gallery_category']) && !empty($jws_option['gallery_category'])) {
          
    
      
            $tabsok = array();
            foreach (  $jws_option['gallery_category'] as $index => $item_tabs ) { 
              $tabsok[ preg_replace('/[^a-zA-Z]+/', '', $item_tabs) ] = $item_tabs;     
           
            };  
            return $tabsok;
        }
        
    
    }
    /**
     * Load style
     */
    public function get_style_depends()
    {
        return [''];
    }

    /**
     * Retrieve the list of scripts the image carousel widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.3.0
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return [''];
    }
 
	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
	    $this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Setting', 'feedy' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
    
        $this->add_control(
				'gallery_display',
				[
					'label'     => esc_html__( 'Display', 'feedy' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'grid',
					'options'   => [
						'grid'   => esc_html__( 'Grid', 'feedy' ),
                        'metro'   => esc_html__( 'Metro', 'feedy' ),
						'slider'   => esc_html__( 'Slider', 'feedy' ),
					],
                    
				]
		);
         $this->add_control(
				'link_action',
				[
					'label'     => esc_html__( 'Link Action', 'feedy' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'lightbox',
					'options'   => [
						'lightbox'   => esc_html__( 'Light Box', 'feedy' ),
                        'linkurl'   => esc_html__( 'Link Href', 'feedy' ),
					],
                    
				]
	     );
        $this->add_control(
			'gallery_layout',
			[
				'label' => esc_html__( 'Layout', 'feedy' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'layout1',
				'options' => [
					'layout1'  => esc_html__( 'Layout 1', 'feedy' ),
				],
			]
		);

        $this->add_responsive_control(
				'gallery_columns',
				[
					'label'          => esc_html__( 'Columns', 'feedy' ),
					'type'           => Controls_Manager::SELECT,
					'default'        => '12',
					'options'        => [
						'12' => '1',
						'6' => '2',
						'4' => '3',
						'3' => '4',
						'20' => '5',
						'2' => '6',
					],
				]
		);
    
         $this->add_control(
    			'images_size',
    			[
    				'label' => __( 'Image Size', 'feedy' ),
    				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
    				'description' => __( 'Image Size', 'feedy' ),
    			]
    	);
        $this->add_control(
				'text_hover',
				[
					'label'     => esc_html__( 'Text Hover', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => 'Feedy',
				]
		);

        $this->end_controls_section(); 
  
	    $this->start_controls_section(
			'setting_section_list',
			[
				'label' => esc_html__( 'gallery List', 'feedy' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);   
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'feedy' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'link_url',
			[
				'label' => esc_html__( 'Link', 'feedy' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'feedy' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
				],
			]
		);


        $this->add_control(
			'list',
			[
				'label' => esc_html__( 'Menu List', 'feedy' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->end_controls_section();
      
        $this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_responsive_control(
			'image_height',
			[
				'label'     => esc_html__( 'Add Height For Image ', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px','%'],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .gallery-image img' => 'height: {{SIZE}}px;',
				],
			]
		);
        
        $this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Columns Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws_gallery .jws_gallery_item' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
					'{{WRAPPER}} .jws_gallery' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'     => esc_html__( 'Rows Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws_gallery .jws_gallery_item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
       $this->add_control(
			'text_hover_color',
			[
				'label'     => esc_html__( 'Text Hover Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws_gallery_element .jws_gallery .gallery-image .overlay-hover .text-hover' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'text_hover_typography',
				'label'     => esc_html__( 'Text Hover Typography', 'feedy' ),
				'selector'  => '{{WRAPPER}} .jws_gallery_element .jws_gallery .gallery-image .overlay-hover .text-hover',
			]
		);
        $this->end_controls_section();
        
          $this->start_controls_section(
			'setting_navigation',
			[
				'label' => esc_html__( 'Setting Navigation', 'feedy' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'	=> [
					'gallery_display' => 'slider',
				],
			]
		);
        $this->add_control(
    				'enable_nav',
    				[
    					'label'        => esc_html__( 'Enable Nav', 'feedy' ),
    					'type'         => Controls_Manager::SWITCHER,
    					'label_on'     => esc_html__( 'Yes', 'feedy' ),
    					'label_off'    => esc_html__( 'No', 'feedy' ),
    					'return_value' => 'yes',
    					'default'      => 'yes',
    					'description'  => esc_html__( 'Enable nav arrow.', 'feedy' ),
    				]
    	);
        
        $this->add_control(
			'nav_layout',
			[
				'label' => esc_html__( 'Nav Layout', 'feedy' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => esc_html__( 'Default', 'feedy' ),
                    'with_number'  => esc_html__( 'With Number', 'feedy' ),
				],
			]
		);

        $this->add_control(
    				'enable_dots',
    				[
    					'label'        => esc_html__( 'Enable Dots', 'feedy' ),
    					'type'         => Controls_Manager::SWITCHER,
    					'label_on'     => esc_html__( 'Yes', 'feedy' ),
    					'label_off'    => esc_html__( 'No', 'feedy' ),
    					'return_value' => 'yes',
    					'default'      => 'yes',
    					'description'  => esc_html__( 'Enable dot.', 'feedy' ),
    				]
    	);
 
        $this->end_controls_section();  
        
        $this->start_controls_section(
			'section_slider_options',
			[
				'label'     => esc_html__( 'Slider Options', 'feedy' ),
				'type'      => Controls_Manager::SECTION,
				'condition' => [
					'gallery_display' => ['slider'],
				],
			]
		);


		$this->add_responsive_control(
			'slides_to_show',
			[
				'label'          => esc_html__( 'posts to Show', 'feedy' ),
				'type'           => Controls_Manager::NUMBER,
			    'condition'    => [
					'variablewidth!'             => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'slides_to_scroll',
			[
				'label'          => esc_html__( 'posts to Scroll', 'feedy' ),
				'type'           => Controls_Manager::NUMBER,
			
			]
		);
        $this->add_control(
			'middle',
			[
				'label'        => esc_html__( 'Slider Middle', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
		$this->add_control(
			'autoplay',
			[
				'label'        => esc_html__( 'Autoplay', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
		$this->add_control(
			'autoplay_speed',
			[
				'label'     => esc_html__( 'Autoplay Speed', 'feedy' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5000,
				'selectors' => [
					'{{WRAPPER}} .slick-slide-bg' => 'animation-duration: calc({{VALUE}}ms*1.2); transition-duration: calc({{VALUE}}ms)',
				],
				'condition' => [
					'autoplay'             => 'yes',
				],
			]
		);
        $this->add_control(
			'auto_smooth',
			[
				'label'        => esc_html__( 'Autoplay Smooth', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
                'condition' => [
					'autoplay'             => 'yes',
				],
			]
		);
		$this->add_control(
			'pause_on_hover',
			[
				'label'        => esc_html__( 'Pause on Hover', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'autoplay'             => 'yes',
				],
			]
		);

		$this->add_control(
			'infinite',
			[
				'label'        => esc_html__( 'Infinite Loop', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
        
        $this->add_control(
			'center',
			[
				'label'        => esc_html__( 'Cener Mode', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
        
        $this->add_control(
			'center_big',
			[
				'label'        => esc_html__( 'Cener Mode Big' , 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => '',
			]
		);
       
        $this->add_control(
			'variablewidth',
			[
				'label'        => esc_html__( 'variable Width', 'feedy' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
        $this->add_responsive_control(
			'variablewidth_width',
			[
				'label'     => esc_html__( 'Add Width For Item Variable Width (px) ', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px','%'],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 350,
				],
				'selectors' => [
					'{{WRAPPER}} .gallery-image' => 'width: {{SIZE}}px;',
				],
                'condition'    => [
					'variablewidth'             => 'yes',
				],
			]
		);
    
		$this->add_control(
			'transition_speed',
			[
				'label'     => esc_html__( 'Transition Speed (ms)', 'feedy' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 500,
			]
		);
		$this->end_controls_section();

	}


	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
	   
		$settings = $this->get_settings_for_display();

          if($settings['gallery_display'] == 'metro') { wp_enqueue_script('isotope'); wp_enqueue_script( 'masonry'); }  
          
          $class_column = 'jws_gallery_item';

          $class_row = 'jws_gallery gallery '.$settings['gallery_layout']; 
          $class_row .= ' '.$settings['gallery_display']; 
          $class_row .= $settings['middle'] == 'yes' ?  ' slider-middle' : ''; 
          $class_row .= ' nav-'.$settings['nav_layout']; 
          
          $class_row .= ' row';

          if($settings['gallery_display'] == 'slider') {
                $class_row .= ' jws-slider owl-carousel';
                $class_column .= ' slider-item'; 
                $dots = ($settings['enable_dots'] == 'yes') ? 'true' : 'false';
                $arrows = ($settings['enable_nav'] == 'yes') ? 'true' : 'false';
                $autoplay = ($settings['autoplay'] == 'yes') ? 'true' : 'false';
                $pause_on_hover = ($settings['pause_on_hover'] == 'yes') ? 'true' : 'false';
                $infinite = ($settings['infinite'] == 'yes') ? 'true' : 'false';
                
                $center = ($settings['center'] == 'yes') ? 'true' : 'false';
                
                if($settings['center_big'] ==  'yes') {
                    
                    $class_row .= ' center-mode';
                    
                }
                
                
                
                $settings['slides_to_show'] = isset($settings['slides_to_show']) && !empty($settings['slides_to_show']) ? $settings['slides_to_show'] : '4';
                $settings['slides_to_show_tablet'] = isset($settings['slides_to_show_tablet']) && !empty($settings['slides_to_show_tablet']) ? $settings['slides_to_show_tablet'] : $settings['slides_to_show'];
                $settings['slides_to_show_mobile'] = isset($settings['slides_to_show_mobile']) && !empty($settings['slides_to_show_mobile']) ? $settings['slides_to_show_mobile'] : $settings['slides_to_show'];
                $settings['slides_to_scroll'] = isset($settings['slides_to_scroll']) && !empty($settings['slides_to_scroll']) ? $settings['slides_to_scroll'] : '1';
                $settings['slides_to_scroll_tablet'] = isset($settings['slides_to_scroll_tablet']) && !empty($settings['slides_to_scroll_tablet']) ? $settings['slides_to_scroll_tablet'] : $settings['slides_to_scroll'];
                $settings['slides_to_scroll_mobile'] = isset($settings['slides_to_scroll_mobile']) && !empty($settings['slides_to_scroll_mobile']) ? $settings['slides_to_scroll_mobile'] : $settings['slides_to_scroll']; 
                
                
                $variableWidth = ($settings['variablewidth'] == 'yes') ? 'true' : 'false';
                
                if($variableWidth == 'true') {
                   $settings['slides_to_show']  = $settings['slides_to_show_tablet'] = $settings['slides_to_show_mobile'] = '1';
                }
                
                $autoplay_speed = (isset($settings['autoplay_speed']) &  !empty($settings['autoplay_speed'])) ? $settings['autoplay_speed'] : '5000';
                
                if($settings['auto_smooth'] == 'yes') {
                    $class_row .= ' auto-smooth';
                }

                
                $data_slick = 'data-owl-option=\'{
                "autoplay": '.$autoplay.',
                "nav": '.$arrows.', 
                "dots":'.$dots.', 
                "autoplayTimeout": '.$autoplay_speed.',
                "autoplaySpeed": '.$autoplay_speed.',
                "autoplayHoverPause":'.$pause_on_hover.',
                "center":'.$center.', 
                "loop":'.$infinite.',
                "autoWidth":'.$variableWidth.',
                "smartSpeed": '.$settings['transition_speed'].', 
                "responsive":{
                    "1024":{"items": '.$settings['slides_to_show'].',"slideBy": '.$settings['slides_to_scroll'].'},
                    "768":{"items": '.$settings['slides_to_show_tablet'].',"slideBy": '.$settings['slides_to_scroll_tablet'].'},
                    "0":{"items": '.$settings['slides_to_show_mobile'].',"slideBy": '.$settings['slides_to_scroll_mobile'].'}
                }}\'';
                
                
                
           }else {
                $class_column .= ' col-xl-'.$settings['gallery_columns'].'';
                $class_column .= (!empty($settings['gallery_columns_tablet'])) ? ' col-lg-'.$settings['gallery_columns_tablet'].'' : ' col-lg-'.$settings['gallery_columns'].'' ;
                $class_column .= (!empty($settings['gallery_columns_mobile'])) ? ' col-'.$settings['gallery_columns_mobile'].'' :  ' col-'.$settings['gallery_columns'].'';   
           
                $data_slick = '';  
            }
        
           $image_size = (!empty($settings['images_size']['width']) || !empty($settings['images_size']['height'])) ? $settings['images_size']['width'].'x'.$settings['images_size']['height'] : 'full';

         ?>
         <div class="jws_gallery_element">

         
            <div class="<?php echo esc_attr($class_row); ?>" <?php echo ''.$data_slick; ?> data-gallery="jws-custom-<?php echo esc_attr($this->get_id()); ?>">
                <?php 
            
                 $i = 1; foreach (  $settings['list'] as $index => $item ) {
                    
                 $link_key = 'link' . $index; 
                 if($settings['link_action'] == 'linkurl') {
                   if($item['link_url']['nofollow']) $this->add_render_attribute( $link_key, 'rel',  'nofollow' );
                   if($item['link_url']['is_external']) $this->add_render_attribute( $link_key, 'target',  '_blank' );  
                   $this->add_render_attribute( $link_key, 'href',  $item['link_url']['url'] ); 
                 }else {
                   $this->add_render_attribute( $link_key, 'class', 'jws-popup-global' );   
                   $this->add_render_attribute( $link_key, 'href',  $item['image']['url'] );
                 }
         
                  $attach_id = $item['image']['id'];
                  $image = jws_image_advanced(array('attach_id' => $attach_id, 'thumb_size' => $image_size));
                  
                  if($settings['gallery_display'] == 'metro') {
                     
                     if($i == 1 || $i == 2 || $i == 3) {
                        $class_column = 'jws_gallery_item  col-4';
                     }else {
                        $class_column = 'jws_gallery_item  col-6';
                     }
                     
                     ?>    
                      
                    <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?php echo esc_attr($class_column); ?>" <?php if($settings['link_action'] == 'lightbox') : ?> data-index="<?php echo esc_attr($i);?>" <?php endif; ?>>
                        <?php include($settings['gallery_layout'].'.php'); ?>
                    </div>
                      
                    <?php
                    
                 
              
                   if ($i == 5) {
                        $i = 1;
                    }else {
                       $i ++;  
                    } 
                    
                  } else {
                    
                
                    ?>
                    
                    <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?php echo esc_attr($class_column); ?>" <?php if($settings['link_action'] == 'lightbox') : ?> data-index="<?php echo esc_attr($i);?>" <?php endif; ?>>
                        <?php include($settings['gallery_layout'].'.php'); ?>
                    </div>
                    
                    <?php
                    
                  }
                    } ?>
            </div>
            <?php if(isset($arrows) && $arrows == 'true') echo '<div class="jws-nav-carousel"><div class="jws-button-prev"></div><div class="jws-button-next"></div></div>'; ?>
         </div>   
        <?php

	}
    


	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}