<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Instagram extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_instagram';
	}
    
	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws Instagram', 'feedy' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-video-camera';
	}
    
    public function get_script_depends() {
        return [
      
        ];
    }

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_instagram_setting',
			[
				'label' => esc_html__( 'Setting', 'feedy' ),
			]
		);
        $this->add_control(
				'layout',
				[
					'label'     => esc_html__( 'Layout', 'feedy' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'grid',
					'options'   => [
                        'grid'   => esc_html__( 'Grid', 'feedy' ),
					],
				]
		);
        $this->add_control(
				'skins',
				[
					'label'     => esc_html__( 'Skins', 'feedy' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'skin1',
					'options'   => [
                        'skin1'   => esc_html__( 'Skin 1', 'feedy' ),
						'skin2'   => esc_html__( 'Skin 2', 'feedy' ),
					],
				]
		);
       $this->add_control(
				'image_limit',
				[
					'label'     => esc_html__( 'Image Limit', 'feedy' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => '9',
				]
		);
        $this->add_control(
				'text_hover',
				[
					'label'     => esc_html__( 'Text Hover', 'feedy' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => 'Feedy',
				]
		);
        $this->add_control(
			'image_size',
			[
				'label' => esc_html__( 'Image Size', 'feedy' ),
				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
				'default' => [
					'width' => '',
					'height' => '',
				],
			]
		  );
        $this->add_responsive_control(
				'align',
				[
					'label' 		=> esc_html__( 'Align', 'feedy' ),
					'type' 			=> Controls_Manager::CHOOSE,
					'default' 		=> 'left',
					'options' 		=> [
						'left'    		=> [
							'title' 	=> esc_html__( 'Left', 'feedy' ),
							'icon' 		=> 'eicon-h-align-left',
						],
						'center' 		=> [
							'title' 	=> esc_html__( 'Center', 'feedy' ),
							'icon' 		=> 'eicon-h-align-center',
						],
						'right' 		=> [
							'title' 	=> esc_html__( 'Right', 'feedy' ),
							'icon' 		=> 'eicon-h-align-right',
						],
					],
                    'selectors' => [
							'{{WRAPPER}} .jws_instagram' => 'text-align: {{VALUE}};',
					],
					'frontend_available' => true,
				]
		);
		$this->add_responsive_control(
			'columns',
			[
				'label'          => esc_html__( 'Columns', 'feedy' ),
				'type'           => Controls_Manager::SELECT,
				'default'        => '3',
				'options'        => [
					'12' => '1',
					'6' => '2',
					'4' => '3',
					'3' => '4',
					'20' => '5',
					'2' => '6',
				],
			]
		);
		 $this->add_control(
    				'enable_animation_scroll',
    				[
    					'label'        => esc_html__( 'Enable Animation When Scroll', 'feedy' ),
    					'type'         => Controls_Manager::SWITCHER,
    					'label_on'     => esc_html__( 'Yes', 'feedy' ),
    					'label_off'    => esc_html__( 'No', 'feedy' ),
    					'return_value' => 'yes',
    					'description'  => esc_html__( 'nable Animation When Scroll (Not Woking With Slider loop)', 'feedy' ),
    				]
    	   );
		$this->end_controls_section();
        
        $this->start_controls_section(
			'section_instagram_list',
			[
				'label' => esc_html__( 'Instagram List', 'feedy' ),
			]
		);
        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'feedy' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        
        $repeater->add_control(
			'link_url',
			[
				'label' => esc_html__( 'Link', 'feedy' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'feedy' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
				],
			]
		);
        
        $this->add_control(
			'list',
			[
				'label' => esc_html__( 'Gallery List', 'feedy' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        
        
        $this->end_controls_section();
        
        
         $this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'feedy' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Columns Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws-instagram-item' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
					'{{WRAPPER}} .instagram-wap' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'     => esc_html__( 'Rows Gap', 'feedy' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws-instagram-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'text_hover_color',
			[
				'label'     => esc_html__( 'Text Hover Color', 'feedy' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .jws-instagram .jws-instagram-inner .overlay .text-hover' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'text_hover_typography',
				'label'     => esc_html__( 'Text Hover Typography', 'feedy' ),
				'selector'  => '{{WRAPPER}} .jws-instagram .jws-instagram-inner .overlay .text-hover',
			]
		);
        

        
        $this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings();
        $id       = $this->get_id();
        $image_size = '400x400';
        if ( ! empty( $settings['list'] ) ) {
		
            $class_column = 'jws-instagram-item ';
            $clasrow = 'row instagram-wap';
            
            if($settings['enable_animation_scroll'] == 'yes') {
                $clasrow .= ' jws-post-animation';
            }
            
          
            $class_column .= 'col-xl-'.$settings['columns'].'';
            $class_column .= (!empty($settings['columns_tablet'])) ? ' col-lg-'.$settings['columns_tablet'].'' : ' col-lg-'.$settings['columns'].'' ;
            $class_column .= (!empty($settings['columns_mobile'])) ? ' col-'.$settings['columns_mobile'].'' :  ' col-'.$settings['columns'].'';
            $loading_icon = '';
            
            $class = 'jws-instagram ';
            $class .= $settings['layout'];
            $class .= ' '.$settings['skins'];
            $image_size = !empty($settings['image_size']['width']) && !empty($settings['image_size']['height']) ?  $settings['image_size']['width'].'x'.$settings['image_size']['height'] : 'full';
            
            
            ?> 
            <div class="<?php echo esc_attr($class); ?>">
            <div class="<?php echo esc_attr($clasrow); ?>">
            <?php
            echo ''.$loading_icon;
            $i = 1;
            foreach (  $settings['list'] as $key => $item ) {
               $link_key = 'link' . $key;  
               if($item['link_url']['nofollow']) $this->add_render_attribute( $link_key, 'rel',  'nofollow' );
               if($item['link_url']['is_external']) $this->add_render_attribute( $link_key, 'target',  '_blank' );  
               $this->add_render_attribute( $link_key, 'href',  $item['link_url']['url'] ); 
                $this->add_render_attribute( $link_key, 'class', 'overlay' );  
                $attach_id = $item['image']['id'];
                $img = jws_getImageBySize(array('attach_id' => $attach_id, 'thumb_size' => $image_size, 'class' => 'instagram-images'));
                $image = jws_image_advanced(array('attach_id' => $attach_id, 'thumb_size' => $image_size));

                ?>
                
                    <div class="<?php echo esc_attr($class_column); ?>">
                        <div class="jws-instagram-inner">
                            <a <?php echo ''.$this->get_render_attribute_string($link_key); ?>>
                                <?php 
                                  if(!empty($settings['text_hover'])) echo '<span class="text-hover">'.$settings['text_hover'].'</span>';
                                ?>
                                <i aria-hidden="true" class="fab fa-instagram"></i>
                            </a>
                            <?php echo !empty($image) ? $image : '';  ?>
                        </div>
                    </div>
                    
                <?php
                
                if ($i == 9) {
                    $i = 1;
                }else {
                   $i ++;  
                } }
            
		}
        ?>
        </div>
        </div>
        <?php
        
	}
    

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}