<?php
/**
 * JWS Particles Module.
 *
 * @package JWS
 */

namespace Elementor;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Module.
 */
class CoLumns_Sticky {
    /**
     * Instance
     *
     * @since 1.2.0
     * @access private
     * @static
     *
     * @var Plugin The single instance of the class.
     */
    private static $_instance = null;
    /**
     * Instance
     *
     * Ensures only one instance of the class is loaded or can be loaded.
     *
     * @since 1.2.0
     * @access public
     *
     * @return Plugin An instance of the class.
     */
    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
    	/**
	 * Constructor.
	 */
	public function __construct() {

	


			$this->add_actions();
	

	}
	/**
	 * Add actions and set scripts dependencies required to run the widget.
	 *
	 * @since 1.12.0
	 * @access protected
	 */
	protected function add_actions() {
        
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
        add_action('elementor/element/column/section_effects/after_section_end', [$this, 'register_controls']);
        
        add_action( 'elementor/frontend/column/before_render', [ $this, '_before_render' ], 10, 1 );


	}
    
    /**
	 * Enqueue scripts.
	 *
	 * Registers all the scripts defined as extension dependencies and enqueues them.
	 *
	 * @since 1.12.0
	 * @access public
	 */
	public function enqueue_scripts() {
	    wp_enqueue_script( 'stick-content', JWS_URI_PATH. '/assets/js/sticky_content.js', array(), '', true );    
	}
    
    	/**
	 * Register shade Animation Backgrounds controls.
	 *
	 * @since 1.12.0
	 * @access public
	 * @param object $element for current element.
	 * @param object $section_id for section ID.
	 * @param array  $args for section args.
	 */
	public function register_controls( $element) {

            
			$element->start_controls_section(
				'jws_columns_sticky',
				[
					'tab'   => Controls_Manager::TAB_ADVANCED,
					/* translators: %s admin link */
					'label' =>  esc_html__( 'Enable Columns Sticky', 'feedy' ) , 
				]
			);
            $element->add_control(
				'jws_enable_columns_sticky',
				[
					'type'         => Controls_Manager::SWITCHER,
					'label'        =>  esc_html__( 'Enable Columns Sticky', 'feedy' ),
					'default'      => '',
					'label_on'     =>  esc_html__( 'Yes', 'feedy' ),
					'label_off'    =>  esc_html__( 'No', 'feedy' ),
					'return_value' => 'yes',
                    'prefix_class' => 'jws-columns-sticky-',
					'render_type'  => 'template',
				]
			);
 

			$element->end_controls_section();
		
	}
	/**
	 * Render Particles Background output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.12.0
	 * @access public
	 * @param object $element for current element.
	 */
	public function _before_render( $element ) {

		if ( $element->get_name() !== 'column' ) {
			return;
		}
        
        $settings = $element->get_settings();
	
	   }
        

        
        
}
// Instantiate Plugin Class
CoLumns_Sticky::instance();
