<?php // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

    function jws_register_meals() {
        global $jws_option;
		$labels = array(
			'name'                => _x( 'Meals', 'Post Type General Name', 'feedy' ),
			'singular_name'       => _x( 'Meals', 'Post Type Singular Name', 'feedy' ),
			'menu_name'           => esc_html__( 'Meals', 'feedy' ),
			'parent_item_colon'   => esc_html__( 'Parent Item:', 'feedy' ),
			'all_items'           => esc_html__( 'All Items', 'feedy' ),
			'view_item'           => esc_html__( 'View Item', 'feedy' ),
			'add_new_item'        => esc_html__( 'Add New Item', 'feedy' ),
			'add_new'             => esc_html__( 'Add New', 'feedy' ),
			'edit_item'           => esc_html__( 'Edit Item', 'feedy' ),
			'update_item'         => esc_html__( 'Update Item', 'feedy' ),
			'search_items'        => esc_html__( 'Search Item', 'feedy' ),
			'not_found'           => esc_html__( 'Not found', 'feedy' ),
			'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'feedy' ),
		);

		$args = array(
			'label'               => esc_html__( 'Meals', 'feedy' ),
		    'labels'              => $labels,
            'supports'            => array( 'title','thumbnail','page-attributes', 'post-formats', ),
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'menu_icon'           => ''.JWS_URI_PATH.'/assets/image/posttyle_icon/meal.png',
            'can_export'          => true,
            'has_archive'         => false,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
		);


        if(function_exists('custom_reg_post_type')){
        	custom_reg_post_type( 'meals', $args );
        }

	
        
    
	};
 add_action( 'init', 'jws_register_meals', 1 );
 
 function add_featured_image_column_meals($defaults) {
    $defaults['price'] = 'Price';
    $defaults['featured_image'] = 'Featured Image';
    $defaults['number_of_meals'] = 'Number of meals';
    unset($defaults['date']);
    return $defaults;
}
add_filter('manage_meals_posts_columns', 'add_featured_image_column_meals');
 
function show_featured_image_column_meals($column_name, $post_id) {
    if ($column_name == 'featured_image') {
        echo get_the_post_thumbnail($post_id, 'thumbnail'); 
    }
    if ($column_name == 'price') {
       echo get_post_meta( $post_id, 'price', true );
    }
    if ($column_name == 'number_of_meals') {
       echo get_post_meta( $post_id, 'number_meals', true );
    }
}
add_action('manage_meals_posts_custom_column', 'show_featured_image_column_meals', 10, 2); 
