<?php // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

    function jws_register_events() {
        global $jws_option;
		$labels = array(
			'name'                => _x( 'Events', 'Post Type General Name', 'feedy' ),
			'singular_name'       => _x( 'Events', 'Post Type Singular Name', 'feedy' ),
			'menu_name'           => esc_html__( 'Events', 'feedy' ),
			'parent_item_colon'   => esc_html__( 'Parent Item:', 'feedy' ),
			'all_items'           => esc_html__( 'All Items', 'feedy' ),
			'view_item'           => esc_html__( 'View Item', 'feedy' ),
			'add_new_item'        => esc_html__( 'Add New Item', 'feedy' ),
			'add_new'             => esc_html__( 'Add New', 'feedy' ),
			'edit_item'           => esc_html__( 'Edit Item', 'feedy' ),
			'update_item'         => esc_html__( 'Update Item', 'feedy' ),
			'search_items'        => esc_html__( 'Search Item', 'feedy' ),
			'not_found'           => esc_html__( 'Not found', 'feedy' ),
			'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'feedy' ),
		);

		$args = array(
			'label'               => esc_html__( 'Events', 'feedy' ),
		    'labels'              => $labels,
            'supports'            => array( 'title', 'editor', 'excerpt', 'thumbnail','page-attributes', 'post-formats', ),
            'taxonomies'          => array( 'events_cat' ),
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'menu_icon'           => 'dashicons-calendar-alt',
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
		);


        if(function_exists('custom_reg_post_type')){
        	custom_reg_post_type( 'events', $args );
        }

		/**
		 * Create a taxonomy category for project
		 *
		 * @uses  Inserts new taxonomy object into the list
		 * @uses  Adds query vars
		 *
		 * @param string  Name of taxonomy object
		 * @param array|string  Name of the object type for the taxonomy object.
		 * @param array|string  Taxonomy arguments
		 * @return null|WP_Error WP_Error if errors, otherwise null.
		 */
		
		$labels = array(
			'name'					=> _x( 'Events Categories', 'Taxonomy plural name', 'feedy' ),
			'singular_name'			=> _x( 'Events Category', 'Taxonomy singular name', 'feedy' ),
			'search_items'			=> esc_html__( 'Search Categories', 'feedy' ),
			'popular_items'			=> esc_html__( 'Popular project Categories', 'feedy' ),
			'all_items'				=> esc_html__( 'All project Categories', 'feedy' ),
			'parent_item'			=> esc_html__( 'Parent Category', 'feedy' ),
			'parent_item_colon'		=> esc_html__( 'Parent Category', 'feedy' ),
			'edit_item'				=> esc_html__( 'Edit Category', 'feedy' ),
			'update_item'			=> esc_html__( 'Update Category', 'feedy' ),
			'add_new_item'			=> esc_html__( 'Add New Category', 'feedy' ),
			'new_item_name'			=> esc_html__( 'New Category', 'feedy' ),
			'add_or_remove_items'	=> esc_html__( 'Add or remove Categories', 'feedy' ),
			'choose_from_most_used'	=> esc_html__( 'Choose from most used text-domain', 'feedy' ),
			'menu_name'				=> esc_html__( 'Category', 'feedy' ),
		);
	
		$args = array(
			'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'events_cat' ),
		);
        

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'events_cat', array( 'events' ), $args  );
        }
        
        $labels = array(
            'name' => esc_html__( 'Tags', 'feedy' ),
            'singular_name' => esc_html__( 'Tag',  'feedy'  ),
            'search_items' =>  esc_html__( 'Search Tags' , 'feedy' ),
            'popular_items' => esc_html__( 'Popular Tags' , 'feedy' ),
            'all_items' => esc_html__( 'All Tags' , 'feedy' ),
            'parent_item' => null,
            'parent_item_colon' => null,
            'edit_item' => esc_html__( 'Edit Tag' , 'feedy' ), 
            'update_item' => esc_html__( 'Update Tag' , 'feedy' ),
            'add_new_item' => esc_html__( 'Add New Tag' , 'feedy' ),
            'new_item_name' => esc_html__( 'New Tag Name' , 'feedy' ),
            'separate_items_with_commas' => esc_html__( 'Separate tags with commas' , 'feedy' ),
            'add_or_remove_items' => esc_html__( 'Add or remove tags' , 'feedy' ),
            'choose_from_most_used' => esc_html__( 'Choose from the most used tags' , 'feedy' ),
            'menu_name' => esc_html__( 'Tags','feedy'),
        ); 
    
        $args = array(
            'hierarchical' => false,
            'labels' => $labels,
            'show_ui' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array( 'slug' => 'events_tag' ),
        );
        
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'events_tag', array( 'events' ), $args  );
        }

	};
add_action( 'init', 'jws_register_events', 1 );

function add_featured_image_column_events($defaults) {
    $defaults['featured_image'] = 'Featured Image';
    return $defaults;
}
add_filter('manage_events_posts_columns', 'add_featured_image_column_events');
 
function show_featured_image_column_events($column_name, $post_id) {
    if ($column_name == 'featured_image') {
        echo get_the_post_thumbnail($post_id, 'thumbnail'); 
    }
}
add_action('manage_events_posts_custom_column', 'show_featured_image_column_events', 10, 2); 
