<?php 

if ( ! function_exists( 'jws_product_rent_available_fields' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_product_rent_available_fields() {
		$product_attributes = array();
        $fields = array();
		if( function_exists( 'wc_get_attribute_taxonomies' ) ) {
			$product_attributes = wc_get_attribute_taxonomies();
		}
    
		if ( count( $product_attributes ) > 0 ) {
			foreach ( $product_attributes as $attribute ) {
				$fields[ $attribute->attribute_name ] = $attribute->attribute_label;
			}	
		}

		return $fields;
	}
}


if( function_exists('acf_add_local_field_group') ):

    
    $key_slug = 'field_product_ingredient_';
    $key_setting = 'product_ingredient';

   acf_add_local_field_group(array(
    'key' => $key_setting,
    'title' => 'Ingredient',
    'fields' => array (),
    'menu_order' => 9999,    
   ));
   acf_add_local_field(array(
        'key' => $key_slug.'ingredient_content',
        'label' => 'Ingredient',
        'name' => 'ingredient_content',
        'type' => 'textarea',
        'rows' => '10',
        'instructions' => 'Please add ingredients line by line.</br> Example: </br> ingredients 1 </br> ingredients 2 </br> ingredients 3',
        'parent' => $key_setting
   ));
   acf_add_local_field(array(
        'key' => $key_slug.'allergen',
        'label' => 'Allergen',
        'name' => 'allergen',
        'type' => 'repeater',
        'layout' => 'table', 
        'parent' => $key_setting,
        'sub_fields' => array(
             array(
                'key' => $key_slug.'ingredient',
                'label' => 'Ingredient',
                'name' => 'ingredient',
                'type' => 'text',
            ),
            array(
                'key' => $key_slug.'status',
                'label' => 'Status',
                'name' => 'status',
                'type' => 'select',
                'allow_null' => false,
                'choices' => jws_allergen_status(),
                'parent' => $key_setting 
            )
        ),
      
        'min' => 0, 
        'max' => 200, 
    ));
    acf_add_local_field(array(
        'key' => $key_slug.'allergen_description',
        'label' => 'Allergen Description',
        'name' => 'allergen_description',
        'type' => 'textarea',
        'rows' => '6',
        'parent' => $key_setting
   ));
   acf_add_local_field(array(
        'key' => $key_slug.'allergen_file',
        'label' => 'Allergen File',
        'name' => 'allergen_file',
        'type' => 'file',
        'return_format' => 'url',
        'parent' => $key_setting
    ));

endif; 


// Add field key of the repeater
add_filter('acf/load_value/key=field_product_ingredient_allergen',  'afc_load_my_repeater_value', 10, 3);
function afc_load_my_repeater_value($value, $post_id, $field) {

    //Optional: Check for post_status otherwise published values will be changed.
    
            $global_allergen = jws_theme_get_option('allergen_global'); 
            
        
            if(!$value) {
                
                   
                
                	$value	= array();
                    
                    
                    if(!empty($global_allergen['redux_repeater_data'])) {
                       foreach($global_allergen['redux_repeater_data'] as $index => $allergen) {
                      
                            if(!empty($global_allergen['ingredient'][$index])) {
                            
                                	$value[] = array(
                        				'field_product_ingredient_ingredient' => $global_allergen['ingredient'][$index],
                                        'field_product_ingredient_status' => $global_allergen['status'][$index]
                        			);
                            
                            }
                       } 
                    }
              
                
           }
		
		
	

	return $value;
}

?>