<?php 

if( function_exists('acf_add_local_field_group') ):

    
    $key_slug = 'field_meals_';
    $key_setting = 'meals_metabox';

    acf_add_local_field_group(array(
        'key' => $key_setting,
        'title' => 'Meals Setting Builder',
        'fields' => array (),
        'location' => array (
            array (
                array (
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'meals',
                ),
            ),
        ),
    ));
    
  acf_add_local_field(array(
        'key' => $key_slug.'tab_setting',
        'label' => 'Setting',
        'name' => 'tab_setting',
        'type' => 'tab',
        'parent' => $key_setting
  ));  
  

   acf_add_local_field(array(
        'key' => $key_slug.'price',
        'label' => 'Meals Price',
        'name' => 'price',
        'type' => 'number',
        'instructions' => 'Ented your meals price.',
        'conditional_logic' => 0,
        'default_value' => '', 
        'placeholder' => '',
        'prepend' => get_woocommerce_currency_symbol(), 
        'append' => '', 
        'min' => 0, 
        'max' => '', 
        'step' => '0.01',
        'parent' => $key_setting
  ));   
  
   acf_add_local_field(array(
        'key' => $key_slug.'number_meals',
        'label' => 'Number of meals',
        'name' => 'number_meals',
        'type' => 'number',
        'instructions' => 'Ented your meals number.',
        'min' => 0, 
        'max' => '', 
        'parent' => $key_setting
  ));  
  
  acf_add_local_field(array(
        'key' => $key_slug.'tab_meals',
        'label' => 'Meals Section',
        'name' => 'tab_meals',
        'type' => 'tab',
        'parent' => $key_setting
  ));
  
  
  acf_add_local_field(array(
    'key' => $key_slug.'meals_query',
    'label' => 'Meals Section',
    'name' => 'meals_query',
    'type' => 'repeater',
    'layout' => 'row', 
    'parent' => $key_setting,
    'sub_fields' => array(
        array(
            'key' => $key_slug.'title',
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
        ),
        array(
            'key' => $key_slug.'query_type',
            'label' => 'Query Type',
            'name' => 'query_type',
            'type' => 'select',
            'choices' => array(
                'all' => 'All Product',
                'cat' => 'Custom Category', 
                'manual' => 'Manual',          
             ),
            'parent' => $key_setting 
        ),
        array(
            'key' =>  $key_slug.'product_cat',
            'label' => 'Product Category',
            'name' => 'product_cat',
            'type' => 'taxonomy',
            'instructions' => 'Select one or more taxonomy terms',
            'taxonomy' => 'product_cat',
            'field_type' => 'checkbox',
            'return_format' => 'id',
            'multiple' => 1, 
            'conditional_logic' => array (
        		array (
        			array (
        			'field' => $key_slug.'query_type',
        			'operator' => '==',
        			'value' => 'cat',
        			),
        		),
        	),
        ),
        array(
            'key' => $key_slug.'include_product',
            'label' => 'Include Product',
            'name' => 'include_product',
            'type' => 'relationship',
            'elements' => array('featured_image'),
            'post_type' => array('product'),
            'multiple' => true,
            'return_format' => 'id',
            'conditional_logic' => array (
        		array (
        			array (
        			'field' => $key_slug.'query_type',
        			'operator' => '==',
        			'value' => 'manual',
        			),
        		),
        	),
        ),
        array(
            'key' => $key_slug.'exclude_product',
            'label' => 'Exclude Product',
            'name' => 'exclude_product',
            'type' => 'post_object',
            'post_type' => array('product'),
            'multiple' => true,
            'return_format' => 'id',
        ),

    ),
  
    'min' => 0, 
    'max' => 200, 
));
  
  
  acf_add_local_field(array(
        'key' => $key_slug.'tab_add_ons',
        'label' => 'Add Ons',
        'name' => 'tab_add_ons',
        'type' => 'tab',
        'parent' => $key_setting
  ));

  acf_add_local_field(array(
    'key' => $key_slug.'addons_query',
    'label' => 'Add ons Section',
    'name' => 'addons_query',
    'type' => 'repeater',
    'layout' => 'row', 
    'parent' => $key_setting,
    'sub_fields' => array(
        array(
            'key' => $key_slug.'title',
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
        ),
        array(
            'key' => $key_slug.'query_type',
            'label' => 'Query Type',
            'name' => 'query_type',
            'type' => 'select',
            'choices' => array(
                'all' => 'All Product',
                'cat' => 'Custom Category', 
                'manual' => 'Manual',          
             ),
            'parent' => $key_setting 
        ),
        array(
            'key' =>  $key_slug.'product_cat',
            'label' => 'Product Category',
            'name' => 'product_cat',
            'type' => 'taxonomy',
            'instructions' => 'Select one or more taxonomy terms',
            'taxonomy' => 'product_cat',
            'field_type' => 'checkbox',
            'return_format' => 'id',
            'multiple' => 1, 
            'conditional_logic' => array (
        		array (
        			array (
        			'field' => $key_slug.'query_type',
        			'operator' => '==',
        			'value' => 'cat',
        			),
        		),
        	),
        ),
        array(
            'key' => $key_slug.'include_product',
            'label' => 'Include Product',
            'name' => 'include_product',
            'type' => 'relationship',
            'elements' => array('featured_image'),
            'post_type' => array('product'),
            'multiple' => true,
            'return_format' => 'id',
            'conditional_logic' => array (
        		array (
        			array (
        			'field' => $key_slug.'query_type',
        			'operator' => '==',
        			'value' => 'manual',
        			),
        		),
        	),
        ),
        array(
            'key' => $key_slug.'exclude_product',
            'label' => 'Exclude Product',
            'name' => 'exclude_product',
            'type' => 'post_object',
            'post_type' => array('product'),
            'multiple' => true,
            'return_format' => 'id',
        ),

    ),
  
    'min' => 0, 
    'max' => 200, 
));
    
endif; 

?>