<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage feedy
 * @since 1.0.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" >
	<meta name="viewport" content="width=device-width, initial-scale=1" >
	<link rel="profile" href="https://gmpg.org/xfn/11" >
	<?php wp_head(); ?>
</head>
<?php  
    global $jws_option; 
?>
<body <?php body_class(); ?>>

<?php wp_body_open(); ?>
   
<div id="page" class="site">
    <?php if(function_exists('jws_header')) jws_header();
     $header_fix = jws_theme_get_option('turn_on_header_sidebar');

     if(!$header_fix && is_page()) {
        $header_fix = get_post_meta( get_the_ID(), 'turn_on_header_sidebar', 1 );
     } 
     if( $header_fix ) {
        ?> 
         
        <div class="header-side">
            <?php  Jws_Elementor::display_header_side(); ?>
        </div>
         
        <?php
     }
    ?>
	<div id="content" class="site-content">
    <?php 
        jws_title_bar();
  
?>