(function($) {
  'use strict';
  $(document)
    .ready(function() {
        
        
       
       $(document).on('click' , '.nav-section a ' , function(e) { 
          
                $('html,body').animate({
                    scrollTop: $($(this).attr('href')).offset().top - 120
                }, 600);
        
       });
        
       $(document).on('click' , '.meals-button.next , .nav-step a ' , function(e) {   
        
           e.preventDefault();
           
           var $step = $(this).data('step');
           
           if($step == 'plan' || $step == 'checkout') return false;
           
           if(!$('[name="step-completed"]').length && ($step == 'add_ons' || $(this).hasClass('meals-button'))) {
              jwsThemeModule.show_notification('You haven\'t added enough meals.','error');
              return false;
           }
 
           var url = $(this).attr('href');
          
           $(document.body).trigger('meals_step_change_ajax', [url, $(this)]);
            
       }); 
       
       $(document.body).on('meals_step_change_ajax', function(e, url, element) { 
                        
                $('html,body').animate({
                    scrollTop: $(".content-area").offset().top - 120
                }, 600);
       
                $('.meals-content').addClass('loading');
                  if(!$('.meals-content').find('.loader').length) {
                    $('.meals-content').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
                  }       
                if ('?' == url.slice(-1)) {
                    url = url.slice(0, -1);
                }
    
                url = url.replace(/%2C/g, ',');
    
                window.history.pushState(null, "", url);
                $(window).bind("popstate", function() {
                    window.location = location.href
                });
          
                
                $.get(url, function(res) {
 
                $('.meals-content > .content').html($(res).find('.meals-content > .content').html());
                $('.meals-content > .sidebar .sidebar-inner').html($(res).find('.meals-content > .sidebar .sidebar-inner').html());
                $('.meals-contailer > .nav-meal').html($(res).find('.meals-contailer > .nav-meal').html());
                $('.meals-content').removeClass('loading');
            }, 'html');
        });
        
       
       $(document).on('click' , '.quanlity-meals a' , function(e) {   
          e.preventDefault();

          var $this = $(this);
          var step = 1;
          var input = $this.parent().find('.quanlity-input');
          var currentVal = parseFloat(input.val());
          if ($this.hasClass('plus')) { 
              if($('[name="step-completed"]').length && !$('.addons-list').length) {
                  jwsThemeModule.show_notification('Added enough meals.','error');
                  return false;
              }
              input.val(currentVal + parseFloat(step));
          } else {
              input.val(currentVal - parseFloat(step));
          }
          input.trigger('change');

            
       }) ;
       
       $(document).on('change' , '.quanlity-meals .quanlity-input' , function(e) {   
          e.preventDefault();
          var input = $(this);
          var id = input.data('id');
          var meals_id = jws_meals.meals_id;
          var quality = input.val();
          var data = {}; 
          data.action = 'change_meals_quanlity_cart';
          data.meals = meals_id;
          data.id = id;
          data.qty = quality;
          data.step = '';
          if($('.cart-add-ons').length) {
              data.step = 'add_ons';
          }
          $('.meals-content').addClass('loading');
          if(!$('.meals-content').find('.loader').length) {
            $('.meals-content').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
          }     
            $.ajax({
                    url: jws_script.ajax_url,
                    data:data,
                    type: 'POST',
                    dataType: 'json',
                    success: function(response) {
       
                      if(response.success) {
                          jwsThemeModule.show_notification(response.data.message,'success');
                      }else {
                          jwsThemeModule.show_notification(response.data[0].message,'error');
                      }
                      if(response.data.cart_result) {
                        $('.my-meals-cart').replaceWith(response.data.cart_result);
                      }
                      
                    },
                    error: function($err) {
                        console.log($err);
                    },
                    complete: function() {$('.meals-content').removeClass('loading');},
           });
            
       }) ;
        
       $(document).on('click' , '.meals-clear-all' , function(e) {   
          e.preventDefault();
          var btn = $(this);
          var meals_id = jws_meals.meals_id;
          var data = {}; 
          data.action = 'reset_meals_to_cart';
          data.meals = meals_id;
          data.step = '';
        
          if($('.cart-add-ons').length) {
              data.step = 'add_ons';
          }
          $('.meals-content').addClass('loading');
          if(!$('.meals-content').find('.loader').length) {
            $('.meals-content').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
          }   
            $.ajax({
                    url: jws_script.ajax_url,
                    data:data,
                    type: 'POST',
                    dataType: 'json',
                    success: function(response) {
                      $('[data-step="meals"]').click();
                      if(response.data.cart_result) {
                        
                        $('.my-meals-cart').replaceWith(response.data.cart_result);
                     
                        
                      }
                    },
                    error: function($err) {
                        console.log($err);
                    },
                    complete: function() {$('.meals-content').removeClass('loading');},
           });
            
       }) ;
        
       $(document).on('click' , '.single-meals .ajax-meal-to-cart' , function(e) {  
          e.preventDefault();
          var btn = $(this);
          var id = btn.data('id');
          var meals_id = jws_meals.meals_id;
          var data = {}; 
          data.action = 'add_meals_to_cart';
          data.id = id; 
          data.meals = meals_id;
          data.step = '';
          if($('.cart-add-ons').length) {
              data.step = 'add_ons';
          }
          $('.meals-content').addClass('loading');
          if(!$('.meals-content').find('.loader').length) {
            $('.meals-content').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
          }   

          if (typeof $.magnificPopup !== 'undefined') { 
                       $.magnificPopup.close();
          } 
            
          $.ajax({
                    url: jws_script.ajax_url,
                    data:data,
                    type: 'POST',
                    dataType: 'json',
                    success: function(response) {
                       
                        $('.show-meals-cart').trigger('click');
                      if(response.success) {
                          jwsThemeModule.show_notification(response.data.message,'success');
                          $('.show-meals-cart').addClass('dots');
                          
                          setTimeout(function(){
                               $('.show-meals-cart').removeClass('dots');  
                          },3000); 
                      }else {
                          jwsThemeModule.show_notification(response.data[0].message,'error');
                      }
     
                     if(response.data.cart_result) {
                         $('.my-meals-cart').replaceWith(response.data.cart_result);
                      }
                    },
                    error: function($err) {
                        console.log($err);
                    },
                    complete: function() {$('.meals-content').removeClass('loading');},
           });
           
        
      });
      
      $(document.body).on('click', '.proceed_to_checkout', function(e) { 
      
        e.preventDefault();
 
                    let $thisbutton = $(this);
                
                
            
                    $thisbutton.addClass('loading');
                    if(!$thisbutton.find('.loader').length) {    
                        $thisbutton.append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
                    }
           
                    $.ajax({
                        url: jws_script.ajax_url,
                        data: {
        					action: 'meals_ajax_add_to_cart',
                            meal_id: jws_meals.meals_id
        				},
                        method: 'POST',
                        success: function(response) {
                            console.log(response);
                            // Redirect to cart option
                            $( 'body' ).trigger( 'update_checkout' );
                            window.location = wc_add_to_cart_params.cart_url;
                            return;
                           
                        },
                        error: function() {
                            console.log('ajax adding to cart error');
                        },
                        complete: function() {$thisbutton.removeClass('loading');},
                    });
                
                
            });
            
          $(document).on('click' , '.product-meals .product-item-inner a:not(.add_to_cart_button)' , function(e) {  
              e.preventDefault();
              var btn = $(this);
              var id = btn.parents('.product-item-inner').find('.add_to_cart_button').data('id');
              var data = {}; 
              data.action = 'meal_detail';
              data.id = id; 
      
              $('.meals-content').addClass('loading');
              if(!$('.meals-content').find('.loader').length) {
                $('.meals-content').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
              }      
        
              $.ajax({
                        url: jws_script.ajax_url,
                        data:data,
                        type: 'POST',
                        dataType: 'json',
                        success: function(response) {
                         
                             $.magnificPopup.open({
                                items: {
                                    src:  response.data.content , // can be a HTML string, jQuery object, or CSS selector
                                    type: 'inline'
                                },
                                removalDelay: 360, //delay removal by X to allow out-animation
                                callbacks: {
                                    beforeOpen: function() {
                                        this.st.mainClass = 'animation-popup';
                                    },
                                    open: function() {
    
                                    }
                                },
                            });
                      
                        },
                        error: function($err) {
                            console.log($err);
                        },
                        complete: function() {$('.meals-content').removeClass('loading');},
               });
               
            
          });
              
    
        
    });
})(jQuery);