var jwsThemeModule;
(function($) {
	"use strict";
	jwsThemeModule = (function() {
		return { 
		    jws_script: jws_script, 
			init: function() {
				this.login_form();
				this.header_sticky();
				this.search_product();
				this.menu_mobile();
				this.scrollTop();
				this.menu_list();
                this.mobile_default();
                this.menu_offset(); 
                this.video_popup();
                this.init_jws_notices();
                this.contact_form_loading();
                this.events_click_hover();
                this.dropdown_ui();
                this.js_main();
                this.post_share();
                this.select2_global();
			},
            
    select2_global: function() {
            $('select').select2({
				dropdownAutoWidth: true,
                minimumResultsForSearch: 10
			});
           
     },        
     js_main: function(container , $item) {

              $(document).on('click','[data-modal-jws]' , function(e) {
                       e.preventDefault();
                       var $buttton = $(this).data('modal-jws');
                   
                        $.magnificPopup.open({
                            items: {
                                src: $buttton,
                                type: 'inline'
                            },
                            removalDelay: 360,
                            tClose: 'close',    
                            callbacks: {
                                beforeOpen: function() {
                                    this.st.mainClass = 'user-popup animation-popup';
                                },
                                open: function() {
                                    
            
                                }
                            },
                        });
               
              });
              
              
              $(document).on('click' , '.show-meals-cart' , function(e) {
                    e.preventDefault();
                    $('.single-meals .meals-content > .sidebar').addClass('open');
              }); 
              $(document).on('click' , '.overlay' , function(e) {
                    $('.single-meals .meals-content > .sidebar').removeClass('open');
              });
              
              
              
              $(document).on('click' , '.jws-dropdown-wap a' , function(e) {
                    e.preventDefault();
                    $(this).parents('.jws-dropdown-wap').toggleClass('active');
                    $(this).parents('.jws-dropdown-wap').find('.dropdown').slideToggle();
              }); 
            
               $(document).on('click' , '.edit-meals' , function(e) {   
                      e.preventDefault();
                      var btn = $(this);
                      var meals_id = btn.data('meal');
                      var cart_key = btn.data('cart');
                      var order_id = btn.data('order');
                      var order_key = btn.data('key');
                      var data = {}; 
                      data.action = 'edit_meals_cart';
                      data.meals = meals_id;
                      data.cart = cart_key;
                      
                      if(order_id !== undefined) {
               
                        data.order_id = order_id;
                        data.order_key = order_key;
                        
                      }
                      
                 
                      btn.addClass('loading');
                        $.ajax({
                                url: jws_script.ajax_url,
                                data:data,
                                type: 'POST',
                                dataType: 'json',
                                success: function(response) {
                                    console.log(response);
                                     if(response.success) {
                                        window.location = response.data.meal_url;
                                     }
                                    
                                },
                                error: function($err) {
                                    console.log($err);
                                },
                                complete: function() {btn.removeClass('loading');},
                       });
                        
                   }) ;
    
        
     },     

            
     owl_caousel_init: function($container) {   
        
       

        $container.data('options',$container.data('owl-option'));
        var options =  $container.data('options');
        var autoplay = false;
  
        if(typeof options != 'undefined'){
            
            autoplay = ( options.autoplay ) ? true : false;

        } 
        
        
        if($container.hasClass('auto-smooth')) {
            options = $.extend({}, options, { "autoplaySpeed": options.autoplayTimeout , "slideTransition": 'linear' });
        }

        options = $.extend({}, options, { "autoplayHoverPause": autoplay });
       
        $container.owlCarousel(options);
       $container.removeAttr("data-owl-option");
        
     },

     show_notification_error: function($content,$role) { 
        
        return 'There is a problem with the network connection, please try again.';
        
     },
       
     show_notification: function($content,$role) {   
        
        
        function createCustomToast() {
            var toastContent = document.createElement("div");
            toastContent.innerHTML  = '<div class="mess-inner fs-small">'+$content+'</div>';
              return toastContent;
        }
        
        if($content) {
 
          var bg = '#438f3e';
          
          if($role == 'error') {
             bg = '#bf9537';
          }
          
               Toastify({
                node: createCustomToast(),
                duration: 4000,
                close:true,
                gravity:'bottom',
                position:'center',
                stopOnFocus:true,
                style: {
                    background:bg,
                },
              }).showToast();     
        }

        
     },

       
            
            
     /**
	 *-------------------------------------------------------------------------------------------------------------------------------------------
	 * Load more button for blog
	 *-------------------------------------------------------------------------------------------------------------------------------------------
	 */
     
      loadmore_btn: function($scope) {
		var $element = $scope.find('[data-ajaxify=true]');
		  var options = $element.data('ajaxify-options');
          if($element.length < 1) return false;
          var wap =  options.wrapper;
	      $(document.body).on('click', '.jws-load-more' , function(e) {
            e.preventDefault();
            var $this = $(this);
            $(this).append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');
            $(this).addClass('loading');
            var url = $this.attr('href');

            if ('?' == url.slice(-1)) {
                url = url.slice(0, -1);
            }

            url = url.replace(/%2C/g, ',');


            $.get(url, function(res) {
         
                var $newItemsWrapper = $(res).find(options.wrapper);
                var $newItems = $newItemsWrapper.find(options.items);
                $this.removeClass('loading');
                if(!$newItems.length) {
                  $this.addClass('all-items-loaded');  
                }
                $(wap).append($newItems);
			
			    $this.find('.loader').remove();
			

                $this.parents('.jws_pagination').html($(res).find(wap).next('.jws_pagination').html());
              
            }, 'html');
        });   
	
	},  
            
            
        dropdown_ui: function() {
                
                $(document).on('click', function(event) {
                     $('.jws-dropdown-ui').removeClass('open');          
                });
                
               $(document).on('click', '.jws-dropdown-ui .dr-button' ,  function(event) {
                    event.stopPropagation();
                    event.preventDefault(); 
                    $('.jws-dropdown-ui').removeClass('open');
                    $(this).parents('.jws-dropdown-ui').toggleClass('open');
                });
   
           },
              
            select2_global: function() {
                //$(document).find('select').niceSelect();
                $('select').select2({
					dropdownAutoWidth: true,
                    minimumResultsForSearch:15
				});
               
           }, 
           
           
              
            fixHeight: function(elem){
                var maxHeight = 0;
                elem.css('height','auto');
                elem.each(function(){
                   if ($(this).height() > maxHeight) { maxHeight = $(this).height(); }
                });
               elem.height(maxHeight);
            },

                
            contact_form_loading: function() {
                $(document).on('click', '.wpcf7-submit', function() {
                    if(!$(this).parents('.wpcf7-form').find('.loader').length) {
                        $(this).parents('.wpcf7-form').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');  
                    }   
                });
                var popup_msg_text = '';
                var popup_text = '';
                var wpcf7Elm = document.querySelectorAll( '.wpcf7' );
                wpcf7Elm.forEach(function(formr){
                formr.addEventListener( 'wpcf7submit', function( event ) {
                    
                    
                        var currentformid = event.detail.contactFormId;
                        var custome = event.detail.apiResponse.status;
                        var popup_message = event.detail.apiResponse.message;
                
                        if(popup_msg_text == ''){
                            popup_text = popup_message;
                        }else{
                            popup_text = popup_msg_text;
                        }
            
                        if(custome == 'validation_failed' || custome == 'mail_failed'){
                            console.log('check');
                            jwsThemeModule.show_notification(popup_text,'error');
                        }else{
                            jwsThemeModule.show_notification(popup_text,'success');
                            console.log('check');
                        }
                        
                        
                }, false ); })
               
        	},
            	jws_carousel: function($scope, $) {
        		$scope.find('.jws-carousel').eq(0).each(function() {
        		    var $this = $(this);  
        	
                    
                var option_attr = $this.find('.carousel').data('slick'); 
               
               if(typeof option_attr === 'undefined' ) return false;
          
               option_attr.navigation = {
                    nextEl: $this.find('.jws-button-next'),
                    prevEl: $this.find('.jws-button-prev'),
               } 
                
               option_attr.pagination = {
                    el: $this.find('.custom_dots'),
                    clickable: true,
               }  
     
                
                if (typeof Swiper !== 'undefined') { 
                     if(option_attr.direction == 'vertical') {
                        $this.find('.carousel').css('height',$this.find('.swiper-slide').height());
                     }   
                     new Swiper($this.find('.carousel'), option_attr);
                }
        		});
                
        
        	},
            
            
            init_jws_notices: function() {
                  $(document).on('click', '.show_filter_shop', function() {
                    $('#jws-shop-topbar').slideToggle();
                    $(this).toggleClass('active');
                    $('.jws-filter-modal').fadeIn().addClass('open');
                    $('.sidebar-sideout').addClass('opened').toggleClass('open');
                });
                $(document).on('click', '.modal-close , .modal-overlay', function() {
                    $('.jws-filter-modal').fadeOut().removeClass('open');
                    $('.show_filter_shop').removeClass('active');
                });
                $('body').on('click', '.jws-icon-cross', function(e) {
                    e.preventDefault(); 
                     var _this = $(this).parents('[role="alert"]');
                    _this.remove();
                  
                });
        
            },


			menu_list: function() {
				$(document).on("click", 'body[data-elementor-device-mode="mobile"] .jws-menu-list.toggle-mobile .menu-list-title', function() {
					$(this).next('ul').slideToggle();
				});
			},

			
			/* Car form for autocomplete input fields*/
			search_product: function() {
			         
                        
                       $('.jws-search-form form').each(function() {
                        
                          var form = $(this);
                          var s = form.find('.s');
                             
                          $(document).on("change", '.jws-search-form .dropdown_product_cat_search', function(e) {
                            e.preventDefault();
                    		form.find('[name="term"]').val($(this).val());
                            s.trigger('keyup'); 
                           
                		  });
                          
                          if(form.hasClass('search-inline')) {
                              s.focus(function() {
                                form.addClass('focused');
                              });
                              $(document).on("click", function(event) {
                                var target = $(event.target);
                                if (!target.closest(".jws-search-form").length) {
                                  form.removeClass("focused");
                                }
                              });
                              
                          }
                          
                          
                         s.on('keyup', function() {
                            
                            
                          var formData = new FormData();
                          
                            formData.append('s', $(this).val());
                            formData.append('term', $('[name="term"]').val());
                            formData.append('action', 'jws_ajax_search');
                                if(!form.find('.form-loader .loader').length) {
                                    form.find('.form-loader').append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');  
                                }
                            
                                form.addClass('search-loading');   
                                $.ajax({
                                url: jws_script.ajax_url,
                                data: formData,
                                method: 'POST',
                                contentType: false,
            			        processData: false,
                                success: function(response) {
                                  
                                  form.removeClass('search-loading');
                                  form.next('.search-results-wrapper').find('.jws-search-results').html(response.data);
                   
                                  
                                },
                                error: function() {
                                  form.next('.search-results-wrapper').find('.jws-search-results').html('<p class="not-found fs-small">Data error re-entering keywords</p>');
                                },
                                complete: function() {},
                            });      
                                    
                                    
                          });
                   
                        
                       }); 
                  
       
			},

			header_sticky: function() {
			    if($('.single-meals').length) {return false;}
				if($('.cafe-row-sticky')[0]) {
				
						$('.cafe-row-sticky').each(function() {
							var $this = $(this);
							var $sidebar = $('.jws_sticky_move');
							var $parent = $(this).parent();
							var current_width = 0;
                            var old_height = $this.outerHeight();
							$(window).resize(function() {
								if(current_width != $(window).width()) {
									current_width = $(window).outerWidth();
									if(current_width > 1024.98 && $this.hasClass('desktop-sticky')) {
										$parent.height(old_height);
									} else if(current_width < 1024.98 && current_width > 768.98 && $this.hasClass('tablet-sticky')) {
										$parent.height($this.outerHeight());
									} else if(current_width < 768.98 && $this.hasClass('mobile-sticky')) {
										$parent.height($this.outerHeight());
									} else {
										$this.removeClass('is-sticky');
										$this.find('.elementor-widget-clever-site-logo').removeClass('header-is-sticky');
                                        $parent.height('auto');
									} 
								}
							}).resize();
							var HeaderTop = $parent.offset().top - $('body').offset().top;
							var old_top_position = 0;
                          
                           
                           
                                
                                $(window).on('scroll', function() {
                                        
                                          
                                        if($('.single-mphb_room_type .room-nav').length) {                                                                                                                                                      
                                         
                                            if($this.parents('.jws_header').length) {
                                           
                                               return false;
                                               
                                            }
                                        }
                                        
        								var top = $(window).scrollTop();
                                        
        								if($this.hasClass('cafe-scroll-up-sticky')) {
        									top = top - $parent.outerHeight();
        									if(old_top_position > top && top > $parent.outerHeight() * 3) {
        										$this.not('.active-sticky').addClass('active-sticky');
        										$this.removeClass('no-active-sticky');
        										$sidebar.removeClass('no-active-sticky');
        									} else {
        										$this.removeClass('active-sticky');
        										if($this.hasClass('is-sticky')) {
        											$this.addClass('no-active-sticky');
        											$sidebar.addClass('no-active-sticky');
        										}
        									}
        									old_top_position = top;
        								}
                                        
                                       
                                      
                                        
        								if(current_width > 1024.98 && $this.hasClass('desktop-sticky')) {
        									if(HeaderTop < top && top > $parent.offset().top) {
        										$this.not('.is-sticky').addClass('is-sticky');
        										$this.find('.elementor-widget-clever-site-logo:not(.header-is-sticky)').addClass('header-is-sticky');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').removeClass('toggle-active');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').find('.wrap-menu-inner').slideUp();
        									} else {
        										$this.removeClass('is-sticky');
        										$this.removeClass('no-active-sticky');
        										$sidebar.removeClass('no-active-sticky');
        										$this.find('.elementor-widget-clever-site-logo').removeClass('header-is-sticky');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').addClass('toggle-active');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').find('.wrap-menu-inner').slideDown();
        									}
        								} else if(current_width < 1024.98 && current_width > 768.98 && $this.hasClass('tablet-sticky')) {
        									if(HeaderTop < top && top > $parent.offset().top) {
        										$this.not('.is-sticky').addClass('is-sticky');
        										$this.find('.elementor-widget-clever-site-logo').addClass('header-is-sticky');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').removeClass('toggle-active');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').find('.wrap-menu-inner').slideUp();
        									} else {
        										$this.removeClass('is-sticky');
        										$this.removeClass('no-active-sticky');
        										$sidebar.removeClass('no-active-sticky');
        										$this.find('.elementor-widget-clever-site-logo').removeClass('header-is-sticky');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').addClass('toggle-active');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').find('.wrap-menu-inner').slideDown();
        									}
        								} else if(current_width < 768.98 && $this.hasClass('mobile-sticky')) {
        									if(HeaderTop < top && top > $parent.offset().top) {
        										$this.not('.is-sticky').addClass('is-sticky');
        										$this.find('.elementor-widget-clever-site-logo:not(.header-is-sticky)').addClass('header-is-sticky');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').removeClass('toggle-active');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').find('.wrap-menu-inner').slideUp();
        									} else {
        										$this.removeClass('is-sticky');
        										$this.removeClass('no-active-sticky');
        										$sidebar.removeClass('no-active-sticky');
        										$this.find('.elementor-widget-clever-site-logo.header-is-sticky').removeClass('header-is-sticky');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').addClass('toggle-active');
        										$('.cafe-wrap-menu .toggle .arrow.on-scroll').parents('.cafe-wrap-menu').find('.wrap-menu-inner').slideDown();
        									}
        								}
                                       
        							});    
                               
                              
			
						});
				
				}
			},
			post_share: function() {
				$('.post-share > span').on('click', function() {
					var parents = $(this).parents('.post-share');
					parents.toggleClass('opened');
					if(parents.hasClass('opened')) {
						parents.find("a").delay(100).each(function(i) {
							$(this).delay(100 * i).queue(function() {
								$(this).addClass("show");
								$(this).dequeue();
							});
						});
					} else {
						parents.find("a").removeClass('show');
					}
				});
			},
			/* ## Theme popup */
			mobile_default: function() {
				$('body').on('click', '.jws-tiger-mobile,.overlay', function() {
					$(this).parents('.elemetor-menu-mobile').toggleClass('active');
				});
			},
			/* ## Theme popup */
			handlePopup: function(data) {
				$(data).each(function() {
					// Activate popup
					$(this).addClass('visible');
					$(this).find('.btn-loading-disabled').addClass('btn-loading');
				});
			},
			scrollTop: function() {
				//Check to see if the window is top if not then display button
				$(window).scroll(function() {
					if($(this).scrollTop() > 100) {
						$('.backToTop').addClass('totop-show');
					} else {
						$('.backToTop').removeClass('totop-show');
					}
				});
				//Click event to scroll to top
				$('.backToTop').on("click", function() {
					$('html, body').animate({
						scrollTop: 0
					}, 1000);
					return false;
				});
			},
			/**
			 *-------------------------------------------------------------------------------------------------------------------------------------------
			 * video popup
			 *-------------------------------------------------------------------------------------------------------------------------------------------
			 */
			video_popup: function() {
				$('.video_format').eq(0).each(function() {
					$('.video_format').magnificPopup({
						delegate: 'a',
						type: 'image',
						removalDelay: 500, //delay removal by X to allow out-animation
						callbacks: {
							beforeOpen: function() {
								this.st.mainClass = 'mfp-zoom-in';
							},
							elementParse: function(item) {
								item.type = 'iframe',
									item.iframe = {
										patterns: {
											youtube: {
												index: 'youtube.com/', // String that detects type of video (in this case YouTube). Simply via url.indexOf(index).
												id: 'v=', // String that splits URL in a two parts, second part should be %id%
												// Or null - full URL will be returned
												// Or a function that should return %id%, for example:
												// id: function(url) { return 'parsed id'; } 
												src: '//www.youtube.com/embed/%id%?autoplay=1' // URL that will be set as a source for iframe. 
											},
											vimeo: {
												index: 'vimeo.com/',
												id: '/',
												src: '//player.vimeo.com/video/%id%?autoplay=1'
											}
										}
									};
							}
						},
					});
				});
			},

            
			menu_offset: function() {
				var setOffset = function(li,$menu) {    
				     
					var $dropdown = li;
					var dropdownWidth = $dropdown.outerWidth();
					var dropdownOffset = $menu.offset();
					var toRight;
					var viewportWidth;
                    var dropdownOffset2;
					var dropdownOffsetRight;
                    var $dropdown_parent = $dropdown.parents('.elementor-column').offset();
					viewportWidth = $(document).width();
					if(!dropdownWidth || !dropdownOffset) {
						return;
					}
                    
                    
                
                    dropdownOffsetRight = viewportWidth - dropdownOffset.left - dropdownWidth;

                    if($dropdown.hasClass('mega_menu')) {
                        
                       if(viewportWidth < dropdownWidth)  { 
                            $menu.addClass('fullwidth');
                            dropdownOffsetRight = - dropdownOffset.left;
                       } else {
                            $menu.removeClass('fullwidth');
                       }
                   
                       if($dropdown.hasClass('left'))  {
                           if(dropdownOffsetRight < 0) {
                               $dropdown.css({
        							left: dropdownOffsetRight
        					   });
                           }else {
                               $dropdown.css({
        							left: 0
        					   }); 
                           } 
                  
                      
                       }
                       
                       
                        dropdownOffset2 = $dropdown.offset();   
    
                       if($dropdown.hasClass('center'))  {
                            
                           dropdownOffsetRight = viewportWidth - dropdownOffset.left  - $menu.outerWidth();
                         
                           let item_offsect = -dropdownWidth / 2 + $menu.outerWidth() / 2; 
                           
                           if(dropdownOffsetRight < dropdownWidth / 2) { 
                            
                               $dropdown.css({
        							right: - dropdownOffsetRight + 15,
                                    left: ''
        					   });
                            
                           }else {
                             
                               $dropdown.css({
        							left: item_offsect
        					   });
                             
                           }
                      
                       } 
                     
                    }
                    
				};
				$('.elementor_jws_menu_layout_menu_horizontal li.menu-item-design-mega_menu_full_width , .elementor_jws_menu_layout_menu_horizontal li.menu-item-design-mega_menu').each(function() {
					var $menu = $(this);
						$menu.find(' > .sub-menu-dropdown').each(function() {
							setOffset($(this),$menu);
						});
				});
			},
			menu_mobile: function() {
			 
                
                 var body = $("body"),
                    dropDownCat = $(".elementor_jws_menu_layout_menu_level .menu-item-has-children ,.elementor_jws_menu_layout_menu_level .menu_has_shortcode"),
                    elementIcon = '<button class="btn-sub-menu jws-icon-angle-right-solid"></button>',
                    elementbutton_submenu = '<li class="menu-title-mobile"><a href="#" class="btn-sub-menu-back"></a></li>',
                    butOpener = $(".btn-sub-menu");
                    dropDownCat.find('> a').append(elementIcon);
                $(elementbutton_submenu).prependTo(dropDownCat.find('> .sub-menu'));
                $(elementbutton_submenu).prependTo(dropDownCat.find('> .sub-menu-dropdown'));
                if (dropDownCat.hasClass("active")) {
                    dropDownCat.addClass("active");
                }
                
                
                     
                
                $(document).on("click", ".elementor_jws_menu_layout_menu_level .btn-sub-menu", function(e) {
                    e.preventDefault();
                 
                    var text = $(this).parent().find('span').text();
              
                    if($(this).closest('li').hasClass('menu_has_shortcode')) {
                        var $parent = $(this).closest('li').find('> .sub-menu-dropdown');
                    } else {
                        var $parent = $(this).closest('li').find('> .sub-menu');
                    }
                    
                    

                       $parent.find('.btn-sub-menu-back').text(text);
                       $parent.addClass('active'); 
                     
                 
                });
     
                  $(document).on("click", ".elementor_jws_menu_layout_menu_level .btn-sub-menu-back", function(e) {
                    e.preventDefault();
                    var $parent = $(this).parent().parent();
                     var $this = $(this);
                     
                        $parent.removeClass("active");    
  
                   
                });
                
             
                   
				var dropDownCat = $(".elementor_jws_menu_layout_menu_vertical .menu-item-has-children ,.elementor_jws_menu_layout_menu_vertical .menu_has_shortcode"),
					elementIcon = '<button class="btn-sub-menu jws-icon-angle-down-solid"></button>';
				$(elementIcon).appendTo(dropDownCat.find('> a'));
				if(dropDownCat.hasClass("active")) {
					dropDownCat.addClass("active");
				}
				$(document).on("click", ".elementor_jws_menu_layout_menu_vertical .btn-sub-menu", function(e) {
				       e.preventDefault();
                  
         
                        $(this).parent().parent().siblings().removeClass('active'); 
                        $(this).parent().parent().siblings().find("> ul,.sub-menu-dropdown").slideUp(320); 
                        
                        $(this).parent().parent().find("> ul").slideToggle(320);
                        $(this).parent().parent().find(".sub-menu-dropdown").slideToggle(320); 

                       
                       if($(this).parent().parent().hasClass('active'))  {
                           $(this).parent().parent().removeClass('active'); 
                         
                        }  else {
                            $(this).parent().parent().addClass('active'); 
                        }
				});
			},
            events_click_hover: function() {
                
                $('.jws-open-login:not(.logged) , .user-not-logged-in .jws_account , .user-not-logged-in .pmpro-plan-button').on('click', function(e) { 
			        event.preventDefault();
			        $('.jws-form-login-popup').addClass('open');
                    $('.jws-offcanvas').removeClass('jws-offcanvas-show');
                    $('.jws-offcanvas-trigger').removeClass('active');
			    });
                $('.jws-close , .jws-form-overlay').on('click', function(e) { 
			        $('.jws-form-login-popup').removeClass('open'); 
			    });
                $('.jws_toolbar_search').on('click', function(e) { 
                    e.preventDefault();
			         $('.form_content_popup').addClass('open');
			    });
                $('.close-form').on('click', function(e) { 
                    e.preventDefault();
			         $('.form_content_popup').removeClass('open');
			    });
                $('.jws-menu-side .menu-expand').on('click', function(e) { 
                    e.preventDefault();
			         $('body').toggleClass('menu-expand');
			    });
                
            },
			login_form: function() {
			    function checkForInput(element,$check) {
 
                      const $label = $(element).parents('.form-row');
                    
                      if ($(element).val().length > 0  || $check) {
                        $label.addClass('entering_text');
                      } else {
                        $label.removeClass('entering_text');
                      }
                }
                
                // The lines below are executed on page load
                $('.jws-animation .input').each(function() {
                  checkForInput(this,false);
                });
                
                // The lines below (inside) are executed on change & keyup
                $('.jws-animation .input').on('change keyup focus', function() {
                  checkForInput(this,true);  
                });
                
                $('.jws-animation .input').on('focus', 
                   function(){
                    checkForInput(this,true); 
                   }).on('focusout', function(){
                    checkForInput(this,false); 
               });
                
                
                
				$('.jws-login-form').each(function() {
					var $this = $(this);
                    
                    
                    if($this.parents('.jws-form-login-popup').length) {
                         $this.find('.form-contaier').owlCarousel({
                            items: 1,
                            touchDrag  : false,
                            mouseDrag  : false,
                            dots:false
                        });
                    }
                    
                   
                    
					$(this).find('form[name=loginpopopform]').on('submit', function(event) {
						event.preventDefault();
                        
						var valid = true,
							email_valid = /[A-Z0-9._%+-]+@[A-Z0-9.-]+.[A-Z]{2,4}/igm;
						$(this).find('input.required').each(function() {
							// Check empty value
							if(!$(this).val()) {
								$(this).addClass('invalid');
								valid = false;
							}
							// Uncheck
							if($(this).is(':checkbox') && !$(this).is(':checked')) {
								$(this).addClass('invalid');
								valid = false;
							}
							// Check email format
							if('email' === $(this).attr('type')) {
								if(!email_valid.test($(this).val())) {
									$(this).addClass('invalid');
									valid = false;
								}
							}
						});
						$(this).find('input.required').on('focus', function() {
							$(this).removeClass('invalid');
						});
						if(!valid) {
							return valid;
						}
						var form = $(this),
							$elem = $this.find('.jws-login-container'),
							wp_submit = $elem.find('input[type=submit]').val();
                        if(!$elem.find('.loader').length) {    
                        $elem.append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
                        }    
						$elem.addClass('loading');
						$elem.find('.jws-login .popup-message').slideUp();
						$elem.find('.message').slideDown().remove();
						var data = {
							action: 'jws_login_ajax',
							data: form.serialize() + '&wp-submit=' + wp_submit,
                            login_security: form.find('#login_security').val(),
						};
                        
                        
                        
                            $.ajax({
                                url: jws_script.ajax_url,
                                data: data,
                                method: 'POST',
                              
                                success: function(response) {
                							if(response.data.code == '1') {
                								if(response.data.redirect) {
                									if(window.location.href == response.data.redirect) {
                										location.reload();
                									} else {
                										window.location.href = response.data.redirect;
                									}
                								} else {
                									location.reload();
                								}
 
                							}
                					
                							$elem.removeClass('loading');
                                          
                                            if(response.success) {
                                              jwsThemeModule.show_notification(response.data.message,'success');
                                            }else {
                                               jwsThemeModule.show_notification(response.data[0].message,'error');
                                            }
                                },
                                error: function() {
                                    jwsThemeModule.show_notification('There is a problem with the internet connection, please try again.','error');
                                    $elem.removeClass('loading');
                                },
                                complete: function() {},
                            });
                       
						return false;
					});
					$(this).find('form[name=registerformpopup]').on('submit', function(e) {
						e.preventDefault();
						var valid = true,
							email_valid = /[A-Z0-9._%+-]+@[A-Z0-9.-]+.[A-Z]{2,4}/igm;
						$(this).find('input.required').each(function() {
							// Check empty value
							if(!$(this).val()) {
								$(this).addClass('invalid');
								valid = false;
							}
							// Uncheck
							if($(this).is(':checkbox') && !$(this).is(':checked')) {
								$(this).addClass('invalid');
								valid = false;
							}
							// Check email format
							if('email' === $(this).attr('type')) {
								if(!email_valid.test($(this).val())) {
									$(this).addClass('invalid');
									valid = false;
								}
							}
						});
						$(this).find('input.required').on('focus', function() {
							$(this).removeClass('invalid');
						});
						if(!valid) {
							return valid;
						}
						var $form = $(this),
							data = {
								action: 'jws_register_ajax',
								data: $form.serialize() + '&wp-submit=' + $form.find('input[type=submit]').val(),
								register_security: $form.find('#register_security').val(),
							},
							$elem = $('#jws-login-form .jws-login-container');
                            if(!$elem.find('.loader').length) {    
                                $elem.append('<div class="loader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/></svg></div>');    
                            } 
						$elem.addClass('loading');
						$elem.find('.jws-register .popup-message').slideUp();
						$elem.find('.message').slideDown().remove();
                       
						$.ajax({
							type: 'POST',
							url: jwsThemeModule.jws_script.ajax_url,
							data: data,
							success: function(response) {
								$elem.removeClass('loading');
						
								if(response.data.code == '1') {
										if(response.data.redirect) {
											if(window.location.href == response.data.redirect) {
												location.reload();
											} else {
												window.location.href = response.data.redirect;
											}
										} else {
											location.reload();
										}
								} 

                                if(response.success) {
                                  jwsThemeModule.show_notification(response.data.message,'success');
                                }else {
                                   jwsThemeModule.show_notification(response.data[0].message,'error');
                                }
							},
						});
					});
					/* Check Strong Passwoed */
					$(this).find('.jws-register input[name="password"]').keyup(function() {
						checkpassword($(this).val());
                        $('.slick-list').css('height','auto');
					});

					function checkpassword(password) {
						var strength = 0,
							meter = $('.meter'),
							meter_text = $('.text-meter'),
							password_hint = $('.jws-password-hint');
						if(password.match(/[a-z]+/)) {
							strength += 1;
						}
						if(password.match(/[A-Z]+/) && password.length >= 8) {
							strength += 1;
						}
						if(password.match(/[0-9]+/) && password.length >= 12) {
							strength += 1;
						}
						if(password.match(/[$@#&!]+/) && password.length >= 14) {
							strength += 1;
						}
						if(password.length > 0) {
							meter.show();
							password_hint.show();
						} else {
							meter.hide();
							password_hint.hide();
						}
						switch(strength) {
							case 0:
								meter_text.html("");
								meter.attr("meter", "0");
								break;
							case 1:
								meter_text.html(jwsThemeModule.jws_script.metera);
								meter.attr("meter", "1");
								break;
							case 2:
								meter_text.html(jwsThemeModule.jws_script.meterb);
								meter.attr("meter", "2");
								break;
							case 3:
								meter_text.html(jwsThemeModule.jws_script.meterc);
								meter.attr("meter", "3");
								password_hint.hide();
								break;
							case 4:
								meter_text.html(jwsThemeModule.jws_script.meterd);
								meter.attr("meter", "4");
								password_hint.hide();
								break;
						}
					}
					$(this).find('.change-form.login').on('click', function(e) {
						e.preventDefault();
						$this.addClass('in-login');
						$this.removeClass('in-register');
                        $this.find('.form-contaier').trigger('to.owl.carousel', 0);
					});
					$(this).find('.change-form.register').on('click', function(e) {
						e.preventDefault();
						$this.removeClass('in-login');
						$this.addClass('in-register');
                        $this.find('.form-contaier').trigger('refresh.owl.carousel');
                        $this.find('.form-contaier').trigger('to.owl.carousel', 1);
                        
					});
					$(this).find(".toggle-password2").click(function() {
						$(this).toggleClass("jws-icon-eye-slash-light");
						$(this).parents('form').find('input[type="password"]').addClass('change-type');
						if($(this).parents('form').find('.change-type').attr("type") == "password") {
							$(this).parents('form').find('.change-type').attr("type", "text");
						} else {
							$(this).parents('form').find('.change-type').attr("type", "password");
						}
					});
				});

			},
			menu_nav: function() {
				var mainMenu = $('.elementor_jws_menu_layout_menu_horizontal').find('.nav'),
					lis = mainMenu.find(' > li.menu-item-design-mega_menu');
				    mainMenu.on('hover', ' > li.menu-item-design-mega_menu', function() {
					setOffset($(this));
				});
				var setOffset = function(li) {
					var dropdown = li.find(' > .sub-menu-dropdown');
					dropdown.attr('style', '');
					var dropdownWidth = dropdown.outerWidth(),
						dropdownOffset = dropdown.offset(),
						screenWidth = $(window).width(),
						viewportWidth = screenWidth,
						extraSpace = 10;
					if(!dropdownWidth || !dropdownOffset) return;
					if(dropdownOffset.left + dropdownWidth >= viewportWidth && li.hasClass('menu-item-design-mega_menu')) {
						// If right point is not in the viewport
						var toRight = dropdownOffset.left + dropdownWidth - viewportWidth;
						dropdown.css({
							left: -toRight - extraSpace
						});
					}
				};
				lis.each(function() {
					setOffset($(this));
					$(this).addClass('with-offsets');
				});
				//mega menu  
				var mega_item = mainMenu.find(' > li.menu-item-design-mega_menu_full_width');
				if(mega_item.length > 0) {
					$('.jws_header').addClass('has-mega-full');
				}
				if($('.elementor_jws_menu_layout_menu_horizontal').hasClass('elementor-jws-menu-change-background-yes')) {
					mega_item.mouseenter(function() {
						$('.jws_header.has-mega-full').addClass('mega-has-hover');
					});
					mega_item.mouseleave(function() {
						$('.jws_header.has-mega-full').removeClass('mega-has-hover');
					});
				}
			},

		};
	}());
	$(document).ready(function() {
		jwsThemeModule.init(); 
	});
	$.fn.isInViewport = function(custom_space) {
		let elementTop = $(this).offset().top + custom_space;
		let elementBottom = elementTop + $(this).outerHeight();
		let viewportTop = $(window).scrollTop();
		let viewportBottom = viewportTop + $(window).height();
  
		return elementBottom > viewportTop && elementTop < viewportBottom;
	};
    
    $(window).on("resize",function(e){ 
        	jwsThemeModule.menu_offset(); 
    });
    

	$.fn.gallery_popup = function(option) {
		if(typeof($.fn.magnificPopup) == 'undefined') return;
		option.find('a.jws-popup-global').magnificPopup({
			type: 'image',
			gallery: {
				enabled: true
			},
			removalDelay: 500, //delay removal by X to allow out-animation
			mainClass: 'gallery-global mfp-zoom-in mfp-img-mobile',
			callbacks: {
				open: function() {
					//overwrite default prev + next function. Add timeout for css3 crossfade animation
					$.magnificPopup.instance.next = function() {
						var self = this;
						self.wrap.removeClass('mfp-image-loaded');
						setTimeout(function() {
							$.magnificPopup.proto.next.call(self);
						}, 120);
					};
					$.magnificPopup.instance.prev = function() {
						var self = this;
						self.wrap.removeClass('mfp-image-loaded');
						setTimeout(function() {
							$.magnificPopup.proto.prev.call(self);
						}, 120);
					};
				},
				imageLoadComplete: function() {
					var self = this;
					setTimeout(function() {
						self.wrap.addClass('mfp-image-loaded');
					}, 16);
				},
			},
		});
	};
    
    
    $.fn.jws_countdown = function(selector) {
		if ($.fn.countdown) {
				var $this = selector,
					untilDate = $this.attr('data-until'),
					compact = $this.attr('data-compact'),
					dateFormat = (!$this.attr('data-format')) ? 'DHMS' : $this.attr('data-format'),
					newLabels = (!$this.attr('data-labels-short')) ?
						['Years', 'Months', 'Weeks', 'Days', 'Hours', 'Minutes', 'Seconds'] :
						['Years', 'Months', 'Weeks', 'Days', 'Hours', 'Mins', 'Secs'],
					newLabels1 = (!$this.attr('data-labels-short')) ?
						['Year', 'Month', 'Week', 'Day', 'Hour', 'Minute', 'Second'] :
						['Year', 'Month', 'Week', 'Day', 'Hour', 'Min', 'Sec'];

				$this.data('countdown') && $this.countdown('destroy');

				if ($(this).hasClass('user-tz')) {
					$this.countdown({
						until: (!$this.attr('data-relative')) ? new Date(untilDate) : untilDate,
						format: dateFormat,
						padZeroes: true,
						compact: compact,
						compactLabels: [' y', ' m', ' w', ' days, '],
						timeSeparator: ' : ',
						labels: newLabels,
						labels1: newLabels1,
						serverSync: new Date($(this).attr('data-time-now'))
					})
				} else {
					$this.countdown({
						until: (!$this.attr('data-relative')) ? new Date(untilDate) : untilDate,
						format: dateFormat,
						padZeroes: true,
						compact: compact,
						compactLabels: [' y', ' m', ' w', ' days, '],
						timeSeparator: ' : ',
						labels: newLabels,
						labels1: newLabels1
					});
				}
		}
	};

})(jQuery);
